/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.operator.BlockedReason;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class StageStats {
    private final DateTime schedulingComplete;
    private final Distribution.DistributionSnapshot getSplitDistribution;
    private final Distribution.DistributionSnapshot scheduleTaskDistribution;
    private final Distribution.DistributionSnapshot addSplitDistribution;
    private final int totalTasks;
    private final int runningTasks;
    private final int completedTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int completedDrivers;
    private final DataSize totalMemoryReservation;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalUserTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;

    @VisibleForTesting
    public StageStats() {
        this.schedulingComplete = null;
        this.getSplitDistribution = null;
        this.scheduleTaskDistribution = null;
        this.addSplitDistribution = null;
        this.totalTasks = 0;
        this.runningTasks = 0;
        this.completedTasks = 0;
        this.totalDrivers = 0;
        this.queuedDrivers = 0;
        this.runningDrivers = 0;
        this.completedDrivers = 0;
        this.totalMemoryReservation = null;
        this.totalScheduledTime = null;
        this.totalCpuTime = null;
        this.totalUserTime = null;
        this.totalBlockedTime = null;
        this.fullyBlocked = false;
        this.blockedReasons = ImmutableSet.of();
        this.rawInputDataSize = null;
        this.rawInputPositions = 0L;
        this.processedInputDataSize = null;
        this.processedInputPositions = 0L;
        this.outputDataSize = null;
        this.outputPositions = 0L;
    }

    @JsonCreator
    public StageStats(@JsonProperty(value="schedulingComplete") DateTime schedulingComplete, @JsonProperty(value="getSplitDistribution") Distribution.DistributionSnapshot getSplitDistribution, @JsonProperty(value="scheduleTaskDistribution") Distribution.DistributionSnapshot scheduleTaskDistribution, @JsonProperty(value="addSplitDistribution") Distribution.DistributionSnapshot addSplitDistribution, @JsonProperty(value="totalTasks") int totalTasks, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="completedTasks") int completedTasks, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="totalMemoryReservation") DataSize totalMemoryReservation, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalUserTime") Duration totalUserTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions) {
        this.schedulingComplete = schedulingComplete;
        this.getSplitDistribution = Objects.requireNonNull(getSplitDistribution, "getSplitDistribution is null");
        this.scheduleTaskDistribution = Objects.requireNonNull(scheduleTaskDistribution, "scheduleTaskDistribution is null");
        this.addSplitDistribution = Objects.requireNonNull(addSplitDistribution, "addSplitDistribution is null");
        Preconditions.checkArgument((totalTasks >= 0 ? 1 : 0) != 0, (Object)"totalTasks is negative");
        this.totalTasks = totalTasks;
        Preconditions.checkArgument((runningTasks >= 0 ? 1 : 0) != 0, (Object)"runningTasks is negative");
        this.runningTasks = runningTasks;
        Preconditions.checkArgument((completedTasks >= 0 ? 1 : 0) != 0, (Object)"completedTasks is negative");
        this.completedTasks = completedTasks;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        this.totalMemoryReservation = Objects.requireNonNull(totalMemoryReservation, "totalMemoryReservation is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalUserTime = Objects.requireNonNull(totalUserTime, "totalUserTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
    }

    @JsonProperty
    public DateTime getSchedulingComplete() {
        return this.schedulingComplete;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getGetSplitDistribution() {
        return this.getSplitDistribution;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getScheduleTaskDistribution() {
        return this.scheduleTaskDistribution;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getAddSplitDistribution() {
        return this.addSplitDistribution;
    }

    @JsonProperty
    public int getTotalTasks() {
        return this.totalTasks;
    }

    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty
    public int getCompletedTasks() {
        return this.completedTasks;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getTotalUserTime() {
        return this.totalUserTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }
}

