/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryQueue;
import com.facebook.presto.execution.QueryQueueDefinition;
import com.facebook.presto.execution.QueryQueueManager;
import com.facebook.presto.execution.QueryQueueRule;
import com.facebook.presto.execution.QueuedExecution;
import com.facebook.presto.execution.SqlQueryManagerStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.jgrapht.DirectedGraph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.FloydWarshallShortestPaths;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedPseudograph;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

@ThreadSafe
public class SqlQueryQueueManager
implements QueryQueueManager {
    private final ConcurrentMap<QueueKey, QueryQueue> queryQueues = new ConcurrentHashMap<QueueKey, QueryQueue>();
    private final List<QueryQueueRule> rules;
    private final MBeanExporter mbeanExporter;

    @Inject
    public SqlQueryQueueManager(QueryManagerConfig config, ObjectMapper mapper, MBeanExporter mbeanExporter) {
        Objects.requireNonNull(config, "config is null");
        this.mbeanExporter = Objects.requireNonNull(mbeanExporter, "mbeanExporter is null");
        ImmutableList.Builder rules = ImmutableList.builder();
        if (config.getQueueConfigFile() == null) {
            QueryQueueDefinition global = new QueryQueueDefinition("global", config.getMaxConcurrentQueries(), config.getMaxQueuedQueries());
            rules.add((Object)new QueryQueueRule(null, null, (Map<String, Pattern>)ImmutableMap.of(), (List<QueryQueueDefinition>)ImmutableList.of((Object)global)));
        } else {
            ManagerSpec managerSpec;
            File file = new File(config.getQueueConfigFile());
            try {
                managerSpec = (ManagerSpec)mapper.readValue(file, ManagerSpec.class);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            HashMap<String, QueryQueueDefinition> definitions = new HashMap<String, QueryQueueDefinition>();
            for (Map.Entry<String, QueueSpec> queue : managerSpec.getQueues().entrySet()) {
                definitions.put(queue.getKey(), new QueryQueueDefinition(queue.getKey(), queue.getValue().getMaxConcurrent(), queue.getValue().getMaxQueued()));
            }
            for (RuleSpec rule : managerSpec.getRules()) {
                rules.add((Object)QueryQueueRule.createRule(rule.getUserRegex(), rule.getSourceRegex(), rule.getSessionPropertyRegexes(), rule.getQueues(), definitions));
            }
        }
        this.rules = rules.build();
        SqlQueryQueueManager.checkIsDAG(this.rules);
    }

    private static void checkIsDAG(List<QueryQueueRule> rules) {
        DirectedPseudograph graph = new DirectedPseudograph(DefaultEdge.class);
        for (QueryQueueRule rule : rules) {
            String lastQueueName = null;
            for (QueryQueueDefinition queue : rule.getQueues()) {
                String currentQueueName = queue.getTemplate();
                graph.addVertex((Object)currentQueueName);
                if (lastQueueName != null) {
                    graph.addEdge((Object)lastQueueName, (Object)currentQueueName);
                }
                lastQueueName = currentQueueName;
            }
        }
        List<String> shortestCycle = SqlQueryQueueManager.shortestCycle((DirectedGraph<String, DefaultEdge>)graph);
        if (shortestCycle != null) {
            String s = Joiner.on((String)", ").join(shortestCycle);
            throw new IllegalArgumentException(String.format("Queues must not contain a cycle. The shortest cycle found is [%s]", s));
        }
    }

    private static List<String> shortestCycle(DirectedGraph<String, DefaultEdge> graph) {
        FloydWarshallShortestPaths floyd = new FloydWarshallShortestPaths(graph);
        int minDistance = Integer.MAX_VALUE;
        String minSource = null;
        String minDestination = null;
        for (DefaultEdge edge : graph.edgeSet()) {
            String src = (String)graph.getEdgeSource((Object)edge);
            String dst = (String)graph.getEdgeTarget((Object)edge);
            int dist = (int)Math.round(floyd.shortestDistance((Object)dst, (Object)src));
            if (dist < 0 || dist >= minDistance) continue;
            minDistance = dist;
            minSource = src;
            minDestination = dst;
        }
        if (minSource == null) {
            return null;
        }
        GraphPath shortestPath = floyd.getShortestPath(minDestination, minSource);
        List pathVertexList = Graphs.getPathVertexList((GraphPath)shortestPath);
        if (!Objects.equals(shortestPath.getStartVertex(), shortestPath.getEndVertex())) {
            pathVertexList.add(pathVertexList.get(0));
        }
        return pathVertexList;
    }

    @Override
    public boolean submit(QueryExecution queryExecution, Executor executor, SqlQueryManagerStats stats) {
        List<QueryQueue> queues = this.selectQueues(queryExecution.getSession(), executor);
        for (QueryQueue queue : queues) {
            if (queue.reserve(queryExecution)) continue;
            return false;
        }
        queues.get(0).enqueue(QueuedExecution.createQueuedExecution(queryExecution, queues.subList(1, queues.size()), executor, stats));
        return true;
    }

    private List<QueryQueue> selectQueues(Session session, Executor executor) {
        for (QueryQueueRule rule : this.rules) {
            List<QueryQueueDefinition> definitions = rule.match(session);
            if (definitions == null) continue;
            return this.getOrCreateQueues(session, executor, definitions);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_ERROR, "Query did not match any queuing rule");
    }

    private List<QueryQueue> getOrCreateQueues(Session session, Executor executor, List<QueryQueueDefinition> definitions) {
        ImmutableList.Builder queues = ImmutableList.builder();
        for (QueryQueueDefinition definition : definitions) {
            QueryQueue queue;
            String expandedName;
            QueueKey key = new QueueKey(definition, expandedName = definition.getExpandedTemplate(session));
            if (!this.queryQueues.containsKey(key) && this.queryQueues.putIfAbsent(key, queue = new QueryQueue(executor, definition.getMaxQueued(), definition.getMaxConcurrent())) == null) {
                String objectName = ObjectNames.builder(QueryQueue.class, (String)definition.getTemplate()).withProperty("expansion", expandedName).build();
                this.mbeanExporter.export(objectName, (Object)queue);
            }
            queues.add(this.queryQueues.get(key));
        }
        return queues.build();
    }

    @PreDestroy
    public void destroy() {
        for (QueueKey key : this.queryQueues.keySet()) {
            String objectName = ObjectNames.builder(QueryQueue.class, (String)key.getQueue().getTemplate()).withProperty("expansion", key.getName()).build();
            this.mbeanExporter.unexport(objectName);
        }
    }

    public static class RuleSpec {
        @Nullable
        private final Pattern userRegex;
        @Nullable
        private final Pattern sourceRegex;
        private final Map<String, Pattern> sessionPropertyRegexes = new HashMap<String, Pattern>();
        private final List<String> queues;

        @JsonCreator
        public RuleSpec(@JsonProperty(value="user") @Nullable Pattern userRegex, @JsonProperty(value="source") @Nullable Pattern sourceRegex, @JsonProperty(value="queues") List<String> queues) {
            this.userRegex = userRegex;
            this.sourceRegex = sourceRegex;
            this.queues = ImmutableList.copyOf(queues);
        }

        @JsonAnySetter
        public void setSessionProperty(String property, Pattern value) {
            Preconditions.checkArgument((boolean)property.startsWith("session."), (String)"Unrecognized property: %s", (Object[])new Object[]{property});
            this.sessionPropertyRegexes.put(property.substring("session.".length(), property.length()), value);
        }

        @Nullable
        public Pattern getUserRegex() {
            return this.userRegex;
        }

        @Nullable
        public Pattern getSourceRegex() {
            return this.sourceRegex;
        }

        public Map<String, Pattern> getSessionPropertyRegexes() {
            return ImmutableMap.copyOf(this.sessionPropertyRegexes);
        }

        public List<String> getQueues() {
            return this.queues;
        }
    }

    public static class QueueSpec {
        private final int maxQueued;
        private final int maxConcurrent;

        @JsonCreator
        public QueueSpec(@JsonProperty(value="maxQueued") int maxQueued, @JsonProperty(value="maxConcurrent") int maxConcurrent) {
            this.maxQueued = maxQueued;
            this.maxConcurrent = maxConcurrent;
        }

        public int getMaxQueued() {
            return this.maxQueued;
        }

        public int getMaxConcurrent() {
            return this.maxConcurrent;
        }
    }

    public static class ManagerSpec {
        private final Map<String, QueueSpec> queues;
        private final List<RuleSpec> rules;

        @JsonCreator
        public ManagerSpec(@JsonProperty(value="queues") Map<String, QueueSpec> queues, @JsonProperty(value="rules") List<RuleSpec> rules) {
            this.queues = ImmutableMap.copyOf(Objects.requireNonNull(queues, "queues is null"));
            this.rules = ImmutableList.copyOf((Collection)Objects.requireNonNull(rules, "rules is null"));
        }

        public Map<String, QueueSpec> getQueues() {
            return this.queues;
        }

        public List<RuleSpec> getRules() {
            return this.rules;
        }
    }

    private static class QueueKey {
        private final QueryQueueDefinition queue;
        private final String name;

        private QueueKey(QueryQueueDefinition queue, String name) {
            this.queue = Objects.requireNonNull(queue, "queue is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public QueryQueueDefinition getQueue() {
            return this.queue;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            QueueKey queueKey = (QueueKey)other;
            return Objects.equals(this.name, queueKey.name) && Objects.equals(this.queue.getTemplate(), queueKey.queue.getTemplate());
        }

        public int hashCode() {
            return Objects.hash(this.queue.getTemplate(), this.name);
        }
    }
}

