/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.SystemMemoryUsageListener;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class SharedBufferMemoryManager {
    private final long maxBufferedBytes;
    private final AtomicLong bufferedBytes = new AtomicLong();
    private final SystemMemoryUsageListener systemMemoryUsageListener;

    public SharedBufferMemoryManager(long maxBufferedBytes, SystemMemoryUsageListener systemMemoryUsageListener) {
        Preconditions.checkArgument((maxBufferedBytes > 0L ? 1 : 0) != 0, (Object)"maxBufferedBytes must be > 0");
        this.maxBufferedBytes = maxBufferedBytes;
        this.systemMemoryUsageListener = Objects.requireNonNull(systemMemoryUsageListener, "systemMemoryUsageListener is null");
    }

    public void updateMemoryUsage(long bytesAdded) {
        this.systemMemoryUsageListener.updateSystemMemoryUsage(bytesAdded);
        this.bufferedBytes.addAndGet(bytesAdded);
    }

    public boolean isFull() {
        return this.bufferedBytes.get() >= this.maxBufferedBytes;
    }
}

