/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.ResetSession;

public class ResetSessionTask
implements DataDefinitionTask<ResetSession> {
    @Override
    public String getName() {
        return "RESET SESSION";
    }

    @Override
    public void execute(ResetSession statement, Session session, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine) {
        if (statement.getName().getParts().size() > 2) {
            throw new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", statement.getName());
        }
        metadata.getSessionPropertyManager().getSessionPropertyMetadata(statement.getName().toString());
        stateMachine.addResetSessionProperties(statement.getName().toString());
    }
}

