/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import io.airlift.configuration.Config;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"query.max-pending-splits-per-node", "experimental.big-query-initial-hash-partitions", "experimental.max-concurrent-big-queries", "experimental.max-queued-big-queries", "query.remote-task.max-consecutive-error-count"})
public class QueryManagerConfig {
    private int scheduleSplitBatchSize = 1000;
    private int maxConcurrentQueries = 1000;
    private int maxQueuedQueries = 5000;
    private String queueConfigFile;
    private int initialHashPartitions = 8;
    private Duration maxQueryAge = new Duration(15.0, TimeUnit.MINUTES);
    private int maxQueryHistory = 100;
    private Duration clientTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private int queryManagerExecutorPoolSize = 5;
    private Duration remoteTaskMinErrorDuration = new Duration(2.0, TimeUnit.MINUTES);
    private int remoteTaskMaxCallbackThreads = 1000;
    private String queryExecutionPolicy = "all-at-once";
    private Duration queryMaxRunTime = new Duration(100.0, TimeUnit.DAYS);

    public String getQueueConfigFile() {
        return this.queueConfigFile;
    }

    @Config(value="query.queue-config-file")
    public QueryManagerConfig setQueueConfigFile(String queueConfigFile) {
        this.queueConfigFile = queueConfigFile;
        return this;
    }

    @Min(value=1L)
    public int getScheduleSplitBatchSize() {
        return this.scheduleSplitBatchSize;
    }

    @Config(value="query.schedule-split-batch-size")
    public QueryManagerConfig setScheduleSplitBatchSize(int scheduleSplitBatchSize) {
        this.scheduleSplitBatchSize = scheduleSplitBatchSize;
        return this;
    }

    @Deprecated
    @Min(value=1L)
    public int getMaxConcurrentQueries() {
        return this.maxConcurrentQueries;
    }

    @Deprecated
    @Config(value="query.max-concurrent-queries")
    public QueryManagerConfig setMaxConcurrentQueries(int maxConcurrentQueries) {
        this.maxConcurrentQueries = maxConcurrentQueries;
        return this;
    }

    @Deprecated
    @Min(value=1L)
    public int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    @Deprecated
    @Config(value="query.max-queued-queries")
    public QueryManagerConfig setMaxQueuedQueries(int maxQueuedQueries) {
        this.maxQueuedQueries = maxQueuedQueries;
        return this;
    }

    @Min(value=1L)
    public int getInitialHashPartitions() {
        return this.initialHashPartitions;
    }

    @Config(value="query.initial-hash-partitions")
    public QueryManagerConfig setInitialHashPartitions(int initialHashPartitions) {
        this.initialHashPartitions = initialHashPartitions;
        return this;
    }

    @NotNull
    public Duration getMaxQueryAge() {
        return this.maxQueryAge;
    }

    @Config(value="query.max-age")
    public QueryManagerConfig setMaxQueryAge(Duration maxQueryAge) {
        this.maxQueryAge = maxQueryAge;
        return this;
    }

    @Min(value=0L)
    public int getMaxQueryHistory() {
        return this.maxQueryHistory;
    }

    @Config(value="query.max-history")
    public QueryManagerConfig setMaxQueryHistory(int maxQueryHistory) {
        this.maxQueryHistory = maxQueryHistory;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="query.client.timeout")
    public QueryManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @Min(value=1L)
    public int getQueryManagerExecutorPoolSize() {
        return this.queryManagerExecutorPoolSize;
    }

    @Config(value="query.manager-executor-pool-size")
    public QueryManagerConfig setQueryManagerExecutorPoolSize(int queryManagerExecutorPoolSize) {
        this.queryManagerExecutorPoolSize = queryManagerExecutorPoolSize;
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public Duration getRemoteTaskMinErrorDuration() {
        return this.remoteTaskMinErrorDuration;
    }

    @Config(value="query.remote-task.min-error-duration")
    public QueryManagerConfig setRemoteTaskMinErrorDuration(Duration remoteTaskMinErrorDuration) {
        this.remoteTaskMinErrorDuration = remoteTaskMinErrorDuration;
        return this;
    }

    @NotNull
    public Duration getQueryMaxRunTime() {
        return this.queryMaxRunTime;
    }

    @Config(value="query.max-run-time")
    public QueryManagerConfig setQueryMaxRunTime(Duration queryMaxRunTime) {
        this.queryMaxRunTime = queryMaxRunTime;
        return this;
    }

    @Min(value=1L)
    public int getRemoteTaskMaxCallbackThreads() {
        return this.remoteTaskMaxCallbackThreads;
    }

    @Config(value="query.remote-task.max-callback-threads")
    public QueryManagerConfig setRemoteTaskMaxCallbackThreads(int remoteTaskMaxCallbackThreads) {
        this.remoteTaskMaxCallbackThreads = remoteTaskMaxCallbackThreads;
        return this;
    }

    @NotNull
    public String getQueryExecutionPolicy() {
        return this.queryExecutionPolicy;
    }

    @Config(value="query.execution-policy")
    public QueryManagerConfig setQueryExecutionPolicy(String queryExecutionPolicy) {
        this.queryExecutionPolicy = queryExecutionPolicy;
        return this;
    }
}

