/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class PageBufferInfo {
    private final int partition;
    private final long bufferedPages;
    private final long queuedPages;
    private final long bufferedBytes;
    private final long pagesAdded;

    @JsonCreator
    public PageBufferInfo(@JsonProperty(value="partition") int partition, @JsonProperty(value="bufferedPages") long bufferedPages, @JsonProperty(value="queuedPages") long queuedPages, @JsonProperty(value="bufferedBytes") long bufferedBytes, @JsonProperty(value="pagesAdded") long pagesAdded) {
        this.partition = partition;
        this.bufferedPages = bufferedPages;
        this.queuedPages = queuedPages;
        this.bufferedBytes = bufferedBytes;
        this.pagesAdded = pagesAdded;
    }

    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    public long getBufferedPages() {
        return this.bufferedPages;
    }

    @JsonProperty
    public long getQueuedPages() {
        return this.queuedPages;
    }

    @JsonProperty
    public long getBufferedBytes() {
        return this.bufferedBytes;
    }

    @JsonProperty
    public long getPagesAdded() {
        return this.pagesAdded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageBufferInfo that = (PageBufferInfo)o;
        return Objects.equals(this.partition, that.partition) && Objects.equals(this.bufferedPages, that.bufferedPages) && Objects.equals(this.queuedPages, that.queuedPages) && Objects.equals(this.bufferedBytes, that.bufferedBytes) && Objects.equals(this.pagesAdded, that.pagesAdded);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.bufferedPages, this.queuedPages, this.bufferedBytes, this.pagesAdded);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partition", this.partition).add("bufferedPages", this.bufferedPages).add("queuedPages", this.queuedPages).add("bufferedBytes", this.bufferedBytes).add("pagesAdded", this.pagesAdded).toString();
    }

    public static PageBufferInfo empty() {
        return new PageBufferInfo(0, 0L, 0L, 0L, 0L);
    }
}

