/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Node;
import java.util.Optional;

public class DropViewTask
implements DataDefinitionTask<DropView> {
    @Override
    public String getName() {
        return "DROP VIEW";
    }

    @Override
    public void execute(DropView statement, Session session, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine) {
        QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        Optional<ViewDefinition> view = metadata.getView(session, name);
        if (!view.isPresent()) {
            if (!statement.isExists()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "View '%s' does not exist", name);
            }
            return;
        }
        accessControl.checkCanDropView(session.getIdentity(), name);
        metadata.dropView(session, name);
    }
}

