/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.ForQueryExecution;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;

public class DataDefinitionExecution<T extends Statement>
implements QueryExecution {
    private final DataDefinitionTask<T> task;
    private final T statement;
    private final Session session;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final QueryStateMachine stateMachine;

    private DataDefinitionExecution(DataDefinitionTask<T> task, T statement, Session session, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine) {
        this.task = Objects.requireNonNull(task, "task is null");
        this.statement = (Statement)Objects.requireNonNull(statement, "statement is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public long getTotalMemoryReservation() {
        return 0L;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void start() {
        block3: {
            try {
                if (!this.stateMachine.transitionToRunning()) {
                    return;
                }
                this.task.execute(this.statement, this.session, this.metadata, this.accessControl, this.stateMachine);
                this.stateMachine.transitionToFinished();
            }
            catch (Throwable e) {
                this.fail(e);
                if (e instanceof RuntimeException) break block3;
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    @Override
    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        return this.stateMachine.waitForStateChange(currentState, maxWait);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void fail(Throwable cause) {
        this.stateMachine.transitionToFailed(cause);
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stateMachine.getQueryInfoWithoutDetails();
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    /* synthetic */ DataDefinitionExecution(DataDefinitionTask x0, Statement x1, Session x2, Metadata x3, AccessControl x4, QueryStateMachine x5, 1 x6) {
        this(x0, x1, x2, x3, x4, x5);
    }

    public static class DataDefinitionExecutionFactory
    implements QueryExecution.QueryExecutionFactory<DataDefinitionExecution<?>> {
        private final LocationFactory locationFactory;
        private final Metadata metadata;
        private final AccessControl accessControl;
        private final ExecutorService executor;
        private final Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks;

        @Inject
        public DataDefinitionExecutionFactory(LocationFactory locationFactory, MetadataManager metadata, AccessControl accessControl, @ForQueryExecution ExecutorService executor, Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks) {
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.executor = Objects.requireNonNull(executor, "executor is null");
            this.tasks = Objects.requireNonNull(tasks, "tasks is null");
        }

        public String explain(Statement statement) {
            DataDefinitionTask<Statement> task = this.getTask(statement);
            Preconditions.checkArgument((task != null ? 1 : 0) != 0, (String)"no task for statement: %s", (Object[])new Object[]{statement.getClass().getSimpleName()});
            return task.explain(statement);
        }

        @Override
        public DataDefinitionExecution<?> createQueryExecution(QueryId queryId, String query, Session session, Statement statement) {
            URI self = this.locationFactory.createQueryLocation(queryId);
            QueryStateMachine stateMachine = new QueryStateMachine(queryId, query, session, self, this.executor);
            return this.createExecution(statement, session, stateMachine);
        }

        private DataDefinitionExecution<?> createExecution(Statement statement, Session session, QueryStateMachine stateMachine) {
            DataDefinitionTask<Statement> task = this.getTask(statement);
            Preconditions.checkArgument((task != null ? 1 : 0) != 0, (String)"no task for statement: %s", (Object[])new Object[]{statement.getClass().getSimpleName()});
            stateMachine.setUpdateType(task.getName());
            return new DataDefinitionExecution(task, statement, session, this.metadata, this.accessControl, stateMachine, null);
        }

        private <T extends Statement> DataDefinitionTask<T> getTask(T statement) {
            return this.tasks.get(statement.getClass());
        }
    }
}

