/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system.jdbc;

import com.facebook.presto.Session;
import com.facebook.presto.connector.system.jdbc.FilterUtil;
import com.facebook.presto.connector.system.jdbc.JdbcTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class TableJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "tables");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.VARCHAR).column("table_schem", (Type)VarcharType.VARCHAR).column("table_name", (Type)VarcharType.VARCHAR).column("table_type", (Type)VarcharType.VARCHAR).column("remarks", (Type)VarcharType.VARCHAR).column("type_cat", (Type)VarcharType.VARCHAR).column("type_schem", (Type)VarcharType.VARCHAR).column("type_name", (Type)VarcharType.VARCHAR).column("self_referencing_col_name", (Type)VarcharType.VARCHAR).column("ref_generation", (Type)VarcharType.VARCHAR).build();
    private final Metadata metadata;

    @Inject
    public TableJdbcTable(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata);
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = FilterUtil.toSession(connectorSession);
        Optional<String> catalogFilter = FilterUtil.stringFilter(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.stringFilter(constraint, 1);
        Optional<String> tableFilter = FilterUtil.stringFilter(constraint, 2);
        Optional<String> typeFilter = FilterUtil.stringFilter(constraint, 3);
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        for (String catalog : FilterUtil.filter(this.metadata.getCatalogNames().keySet(), catalogFilter)) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            if (FilterUtil.emptyOrEquals(typeFilter, "TABLE")) {
                for (QualifiedObjectName name : this.metadata.listTables(session, prefix)) {
                    table.addRow(TableJdbcTable.tableRow(name, "TABLE"));
                }
            }
            if (!FilterUtil.emptyOrEquals(typeFilter, "VIEW")) continue;
            for (QualifiedObjectName name : this.metadata.listViews(session, prefix)) {
                table.addRow(TableJdbcTable.tableRow(name, "VIEW"));
            }
        }
        return table.build().cursor();
    }

    private static Object[] tableRow(QualifiedObjectName name, String type) {
        return new Object[]{name.getCatalogName(), name.getSchemaName(), name.getObjectName(), type, null, null, null, null, null, null};
    }
}

