/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.connector.system.SystemTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import java.util.Objects;

public class SystemHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    public SystemHandleResolver(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof SystemTableHandle && ((SystemTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ColumnHandle columnHandle) {
        return columnHandle instanceof SystemColumnHandle && ((SystemColumnHandle)columnHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof SystemSplit && ((SystemSplit)split).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorTableLayoutHandle handle) {
        return handle instanceof SystemTableLayoutHandle && ((SystemTableLayoutHandle)handle).getConnectorId().equals(this.connectorId);
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return SystemTableHandle.class;
    }

    public Class<? extends ConnectorTableLayoutHandle> getTableLayoutHandleClass() {
        return SystemTableLayoutHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return SystemColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return SystemSplit.class;
    }
}

