/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemConnector;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SystemTable;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class SystemConnectorFactory
implements ConnectorFactory {
    private final NodeManager nodeManager;
    private final Set<SystemTable> tables;

    @Inject
    public SystemConnectorFactory(NodeManager nodeManager, Set<SystemTable> tables) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.tables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(tables, "tables is null"));
    }

    public String getName() {
        return "system";
    }

    public Connector create(String connectorId, Map<String, String> config) {
        return new SystemConnector(connectorId, this.nodeManager, this.tables);
    }
}

