/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplit;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import java.util.Objects;

public class InformationSchemaHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    public InformationSchemaHandleResolver(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof InformationSchemaTableHandle && ((InformationSchemaTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ColumnHandle columnHandle) {
        return columnHandle instanceof InformationSchemaColumnHandle && ((InformationSchemaColumnHandle)columnHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof InformationSchemaSplit && ((InformationSchemaSplit)split).getConnectorId().equals(this.connectorId);
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return InformationSchemaTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return InformationSchemaColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return InformationSchemaSplit.class;
    }
}

