/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaHandleResolver;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.connector.informationSchema.InformationSchemaPageSourceProvider;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplitManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.NodeManager;
import java.util.Objects;

public class InformationSchemaConnector
implements Connector {
    private final ConnectorHandleResolver handleResolver;
    private final ConnectorMetadata metadata;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;

    public InformationSchemaConnector(String connectorId, String catalogName, NodeManager nodeManager, Metadata metadata) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.handleResolver = new InformationSchemaHandleResolver(connectorId);
        this.metadata = new InformationSchemaMetadata(connectorId, catalogName);
        this.splitManager = new InformationSchemaSplitManager(nodeManager);
        this.pageSourceProvider = new InformationSchemaPageSourceProvider(metadata);
    }

    public ConnectorHandleResolver getHandleResolver() {
        return this.handleResolver;
    }

    public ConnectorMetadata getMetadata() {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }
}

