/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class InformationSchemaColumnHandle
implements ColumnHandle {
    private final String connectorId;
    private final String columnName;

    @JsonCreator
    public InformationSchemaColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="columnName") String columnName) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.columnName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InformationSchemaColumnHandle other = (InformationSchemaColumnHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.columnName, other.columnName);
    }

    public String toString() {
        return this.connectorId + ":" + this.columnName;
    }

    public static Map<String, ColumnHandle> toInformationSchemaColumnHandles(String connectorId, ConnectorTableMetadata tableMetadata) {
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            columnHandles.put((Object)columnMetadata.getName(), (Object)new InformationSchemaColumnHandle(connectorId, columnMetadata.getName()));
        }
        return columnHandles.build();
    }
}

