/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.connector.informationSchema.InformationSchemaConnector;
import com.facebook.presto.connector.system.SystemConnector;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorPageSinkProvider;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.security.ConnectorAccessControl;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.RecordPageSinkProvider;
import com.facebook.presto.split.RecordPageSourceProvider;
import com.facebook.presto.split.SplitManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.airlift.log.Logger;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class ConnectorManager {
    public static final String INFORMATION_SCHEMA_CONNECTOR_PREFIX = "$info_schema@";
    public static final String SYSTEM_TABLES_CONNECTOR_PREFIX = "$system@";
    private static final Logger log = Logger.get(ConnectorManager.class);
    private final MetadataManager metadataManager;
    private final AccessControlManager accessControlManager;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final PageSinkManager pageSinkManager;
    private final HandleResolver handleResolver;
    private final NodeManager nodeManager;
    private final ConcurrentMap<String, ConnectorFactory> connectorFactories = new ConcurrentHashMap<String, ConnectorFactory>();
    private final Set<String> catalogs = Sets.newConcurrentHashSet();
    private final ConcurrentMap<String, Connector> connectors = new ConcurrentHashMap<String, Connector>();
    private final AtomicBoolean stopped = new AtomicBoolean();

    @Inject
    public ConnectorManager(MetadataManager metadataManager, AccessControlManager accessControlManager, SplitManager splitManager, PageSourceManager pageSourceManager, IndexManager indexManager, PageSinkManager pageSinkManager, HandleResolver handleResolver, NodeManager nodeManager) {
        this.metadataManager = metadataManager;
        this.accessControlManager = accessControlManager;
        this.splitManager = splitManager;
        this.pageSourceManager = pageSourceManager;
        this.indexManager = indexManager;
        this.pageSinkManager = pageSinkManager;
        this.handleResolver = handleResolver;
        this.nodeManager = nodeManager;
    }

    @PreDestroy
    public void stop() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        for (Map.Entry entry : this.connectors.entrySet()) {
            Connector connector = (Connector)entry.getValue();
            try {
                ThreadContextClassLoader ignored = new ThreadContextClassLoader(connector.getClass().getClassLoader());
                Throwable throwable = null;
                try {
                    connector.shutdown();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (Throwable t) {
                log.error(t, "Error shutting down connector: %s", new Object[]{entry.getKey()});
            }
        }
    }

    public void addConnectorFactory(ConnectorFactory connectorFactory) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        ConnectorFactory existingConnectorFactory = this.connectorFactories.putIfAbsent(connectorFactory.getName(), connectorFactory);
        Preconditions.checkArgument((existingConnectorFactory == null ? 1 : 0) != 0, (String)"Connector %s is already registered", (Object[])new Object[]{connectorFactory.getName()});
    }

    public synchronized void createConnection(String catalogName, String connectorName, Map<String, String> properties) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(connectorName, "connectorName is null");
        Objects.requireNonNull(properties, "properties is null");
        ConnectorFactory connectorFactory = (ConnectorFactory)this.connectorFactories.get(connectorName);
        Preconditions.checkArgument((connectorFactory != null ? 1 : 0) != 0, (String)"No factory for connector %s", (Object[])new Object[]{connectorName});
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(connectorFactory.getClass().getClassLoader());){
            this.createConnection(catalogName, connectorFactory, properties);
        }
    }

    public synchronized void createConnection(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(properties, "properties is null");
        Objects.requireNonNull(connectorFactory, "connectorFactory is null");
        Preconditions.checkArgument((!this.catalogs.contains(catalogName) ? 1 : 0) != 0, (String)"A catalog already exists for %s", (Object[])new Object[]{catalogName});
        String connectorId = ConnectorManager.getConnectorId(catalogName);
        Preconditions.checkState((!this.connectors.containsKey(connectorId) ? 1 : 0) != 0, (String)"A connector %s already exists", (Object[])new Object[]{connectorId});
        Connector connector = connectorFactory.create(connectorId, properties);
        this.addCatalogConnector(catalogName, connectorId, connector);
        this.catalogs.add(catalogName);
    }

    private synchronized void addCatalogConnector(String catalogName, String connectorId, Connector connector) {
        this.addConnectorInternal(ConnectorType.STANDARD, catalogName, connectorId, connector);
        String informationSchemaId = ConnectorManager.makeInformationSchemaConnectorId(connectorId);
        this.addConnectorInternal(ConnectorType.INFORMATION_SCHEMA, catalogName, informationSchemaId, new InformationSchemaConnector(informationSchemaId, catalogName, this.nodeManager, this.metadataManager));
        String systemId = ConnectorManager.makeSystemTablesConnectorId(connectorId);
        this.addConnectorInternal(ConnectorType.SYSTEM, catalogName, systemId, new SystemConnector(systemId, this.nodeManager, connector.getSystemTables()));
        this.metadataManager.getSessionPropertyManager().addConnectorSessionProperties(catalogName, connector.getSessionProperties());
        this.metadataManager.getTablePropertyManager().addTableProperties(catalogName, connector.getTableProperties());
    }

    private synchronized void addConnectorInternal(ConnectorType type, String catalogName, String connectorId, Connector connector) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        Preconditions.checkState((!this.connectors.containsKey(connectorId) ? 1 : 0) != 0, (String)"A connector %s already exists", (Object[])new Object[]{connectorId});
        this.connectors.put(connectorId, connector);
        ConnectorMetadata connectorMetadata = connector.getMetadata();
        Preconditions.checkState((connectorMetadata != null ? 1 : 0) != 0, (String)"Connector %s can not provide metadata", (Object[])new Object[]{connectorId});
        ConnectorSplitManager connectorSplitManager = connector.getSplitManager();
        Preconditions.checkState((connectorSplitManager != null ? 1 : 0) != 0, (String)"Connector %s does not have a split manager", (Object[])new Object[]{connectorId});
        Set systemTables = connector.getSystemTables();
        Objects.requireNonNull(systemTables, "Connector %s returned a null system tables set");
        ConnectorPageSourceProvider connectorPageSourceProvider = null;
        try {
            connectorPageSourceProvider = connector.getPageSourceProvider();
            Objects.requireNonNull(connectorPageSourceProvider, String.format("Connector %s returned a null page source provider", connectorId));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (connectorPageSourceProvider == null) {
            ConnectorRecordSetProvider connectorRecordSetProvider = null;
            try {
                connectorRecordSetProvider = connector.getRecordSetProvider();
                Objects.requireNonNull(connectorRecordSetProvider, String.format("Connector %s returned a null record set provider", connectorId));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            Preconditions.checkState((connectorRecordSetProvider != null ? 1 : 0) != 0, (String)"Connector %s has neither a PageSource or RecordSet provider", (Object[])new Object[]{connectorId});
            connectorPageSourceProvider = new RecordPageSourceProvider(connectorRecordSetProvider);
        }
        ConnectorHandleResolver connectorHandleResolver = connector.getHandleResolver();
        Objects.requireNonNull(connectorHandleResolver, String.format("Connector %s does not have a handle resolver", connectorId));
        ConnectorPageSinkProvider connectorPageSinkProvider = null;
        try {
            connectorPageSinkProvider = connector.getPageSinkProvider();
            Objects.requireNonNull(connectorPageSinkProvider, String.format("Connector %s returned a null page sink provider", connectorId));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (connectorPageSinkProvider == null) {
            ConnectorRecordSinkProvider connectorRecordSinkProvider = null;
            try {
                connectorRecordSinkProvider = connector.getRecordSinkProvider();
                Objects.requireNonNull(connectorRecordSinkProvider, String.format("Connector %s returned a null record sink provider", connectorId));
                connectorPageSinkProvider = new RecordPageSinkProvider(connectorRecordSinkProvider);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        ConnectorIndexResolver indexResolver = null;
        try {
            indexResolver = connector.getIndexResolver();
            Objects.requireNonNull(indexResolver, String.format("Connector %s returned a null index resolver", connectorId));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Objects.requireNonNull(connector.getSessionProperties(), String.format("Connector %s returned null session properties", connectorId));
        Objects.requireNonNull(connector.getTableProperties(), String.format("Connector %s returned null table properties", connectorId));
        ConnectorAccessControl accessControl = null;
        try {
            accessControl = connector.getAccessControl();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (type == ConnectorType.STANDARD) {
            this.metadataManager.addConnectorMetadata(connectorId, catalogName, connectorMetadata);
        } else if (type == ConnectorType.INFORMATION_SCHEMA) {
            this.metadataManager.addInformationSchemaMetadata(connectorId, catalogName, connectorMetadata);
        } else if (type == ConnectorType.SYSTEM) {
            this.metadataManager.addSystemTablesMetadata(connectorId, catalogName, connectorMetadata);
        } else {
            throw new IllegalArgumentException("Unhandled type: " + (Object)((Object)type));
        }
        this.splitManager.addConnectorSplitManager(connectorId, connectorSplitManager);
        this.handleResolver.addHandleResolver(connectorId, connectorHandleResolver);
        this.pageSourceManager.addConnectorPageSourceProvider(connectorId, connectorPageSourceProvider);
        if (connectorPageSinkProvider != null) {
            this.pageSinkManager.addConnectorPageSinkProvider(connectorId, connectorPageSinkProvider);
        }
        if (indexResolver != null) {
            this.indexManager.addIndexResolver(connectorId, indexResolver);
        }
        if (accessControl != null) {
            this.accessControlManager.addCatalogAccessControl(catalogName, accessControl);
        }
    }

    private static String makeInformationSchemaConnectorId(String connectorId) {
        return INFORMATION_SCHEMA_CONNECTOR_PREFIX + connectorId;
    }

    private static String makeSystemTablesConnectorId(String connectorId) {
        return SYSTEM_TABLES_CONNECTOR_PREFIX + connectorId;
    }

    private static String getConnectorId(String catalogName) {
        return catalogName;
    }

    private static enum ConnectorType {
        STANDARD,
        INFORMATION_SCHEMA,
        SYSTEM;

    }
}

