/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class SetFieldByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;
    private final ParameterizedType declaringClass;
    private final String name;
    private final ByteCodeExpression value;
    private final ParameterizedType fieldType;

    public SetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, Class<?> declaringClass, String name, ByteCodeExpression value) {
        this(instance, SetFieldByteCodeExpression.getDeclaredField(declaringClass, name), value);
    }

    public SetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, Field field, ByteCodeExpression value) {
        this(instance, ParameterizedType.type(Objects.requireNonNull(field, "field is null").getDeclaringClass()), field.getName(), value, ParameterizedType.type(field.getType()));
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (instance == null) {
            Preconditions.checkArgument((boolean)isStatic, (String)"Field is not static: %s", (Object[])new Object[]{field});
        } else {
            Preconditions.checkArgument((!isStatic ? 1 : 0) != 0, (String)"Field is static: %s", (Object[])new Object[]{field});
        }
    }

    public SetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, FieldDefinition field, ByteCodeExpression value) {
        this(instance, Objects.requireNonNull(field, "field is null").getDeclaringClass().getType(), field.getName(), value, field.getType());
        if (instance == null) {
            Preconditions.checkArgument((boolean)field.getAccess().contains((Object)Access.STATIC), (String)"Field is not static: %s", (Object[])new Object[]{field});
        } else {
            Preconditions.checkArgument((!field.getAccess().contains((Object)Access.STATIC) ? 1 : 0) != 0, (String)"Field is static: %s", (Object[])new Object[]{field});
        }
    }

    public SetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, ParameterizedType declaringClass, String name, ByteCodeExpression value) {
        this(instance, declaringClass, name, value, value.getType());
    }

    public SetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, ParameterizedType declaringClass, String name, ByteCodeExpression value, ParameterizedType fieldType) {
        super(ParameterizedType.type(Void.TYPE));
        if (instance != null) {
            Preconditions.checkArgument((!instance.getType().isPrimitive() ? 1 : 0) != 0, (String)"Type %s does not have fields", (Object[])new Object[]{instance.getType()});
        }
        this.instance = instance;
        this.declaringClass = Objects.requireNonNull(declaringClass, "declaringClass is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.fieldType = Objects.requireNonNull(fieldType, "fieldType is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        if (this.instance == null) {
            return new ByteCodeBlock().append(this.value.getByteCode(generationContext)).putStaticField(this.declaringClass, this.name, this.fieldType);
        }
        return new ByteCodeBlock().append(this.instance.getByteCode(generationContext)).append(this.value.getByteCode(generationContext)).putField(this.declaringClass, this.name, this.fieldType);
    }

    @Override
    protected String formatOneLine() {
        if (this.instance == null) {
            return this.declaringClass.getSimpleName() + "." + this.name + " = " + this.value;
        }
        return this.instance + "." + this.name + " = " + this.value;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        ImmutableList.Builder children = ImmutableList.builder();
        if (this.instance != null) {
            children.add((Object)this.instance);
        }
        children.add((Object)this.value);
        return children.build();
    }

    private static Field getDeclaredField(Class<?> declaringClass, String name) {
        Objects.requireNonNull(declaringClass, "declaringClass is null");
        Objects.requireNonNull(name, "name is null");
        try {
            return declaringClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("Class %s does not have a '%s' field", declaringClass.getName(), name));
        }
    }
}

