/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ArrayOpCode;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class SetArrayElementByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;
    private final ByteCodeExpression index;
    private final ByteCodeExpression value;
    private final InstructionNode arrayStoreInstruction;

    public SetArrayElementByteCodeExpression(ByteCodeExpression instance, ByteCodeExpression index, ByteCodeExpression value) {
        super(ParameterizedType.type(Void.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.index = Objects.requireNonNull(index, "index is null");
        this.value = Objects.requireNonNull(value, "value is null");
        ParameterizedType componentType = instance.getType().getArrayComponentType();
        Preconditions.checkArgument((index.getType().getPrimitiveType() == Integer.TYPE ? 1 : 0) != 0, (Object)("index must be int type, but is " + index.getType()));
        Preconditions.checkArgument((boolean)componentType.equals(value.getType()), (String)"value must be %s type, but is %s", (Object[])new Object[]{componentType, value.getType()});
        this.arrayStoreInstruction = ArrayOpCode.getArrayOpCode(componentType).getStore();
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return new ByteCodeBlock().append(this.instance.getByteCode(generationContext)).append(this.index).append(this.value).append(this.arrayStoreInstruction);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + "[" + this.index + "] = " + this.value;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.index, (Object)this.value);
    }
}

