/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class ReturnByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;
    private final OpCode returnOpCode;

    ReturnByteCodeExpression(ByteCodeExpression instance) {
        super(ParameterizedType.type(Void.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.returnOpCode = ReturnByteCodeExpression.returnOpCode(instance.getType());
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return new ByteCodeBlock().append(this.instance.getByteCode(generationContext)).append(this.returnOpCode);
    }

    @Override
    protected String formatOneLine() {
        return "return " + this.instance;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.instance);
    }

    private static OpCode returnOpCode(ParameterizedType componentType) {
        Class<?> primitiveType = componentType.getPrimitiveType();
        if (primitiveType != null) {
            if (primitiveType == Byte.TYPE || primitiveType == Boolean.TYPE || primitiveType == Character.TYPE || primitiveType == Short.TYPE || primitiveType == Integer.TYPE) {
                return OpCode.IRETURN;
            }
            if (primitiveType == Long.TYPE) {
                return OpCode.LRETURN;
            }
            if (primitiveType == Float.TYPE) {
                return OpCode.FRETURN;
            }
            if (primitiveType == Double.TYPE) {
                return OpCode.DRETURN;
            }
            if (primitiveType == Void.TYPE) {
                return OpCode.RETURN;
            }
            throw new IllegalArgumentException("Unsupported array type: " + primitiveType);
        }
        return OpCode.ARETURN;
    }
}

