/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.TypeInstruction;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class NewArrayByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression length;
    private final ParameterizedType type;

    public NewArrayByteCodeExpression(ParameterizedType type, int length) {
        this(type, ByteCodeExpressions.constantInt(length));
    }

    public NewArrayByteCodeExpression(ParameterizedType type, ByteCodeExpression length) {
        super(type);
        this.type = Objects.requireNonNull(type, "type is null");
        this.length = Objects.requireNonNull(length, "length is null");
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        if (this.type.getArrayComponentType().isPrimitive()) {
            return new ByteCodeBlock().append(this.length).append(TypeInstruction.newPrimitiveArray(this.type.getArrayComponentType()));
        }
        return new ByteCodeBlock().append(this.length).append(TypeInstruction.newObjectArray(this.type.getArrayComponentType()));
    }

    @Override
    protected String formatOneLine() {
        return "new " + this.getType().getArrayComponentType().getSimpleName() + "[" + this.length + "]";
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

