/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class InvokeByteCodeExpression
extends ByteCodeExpression {
    @Nullable
    private final ByteCodeExpression instance;
    private final ParameterizedType methodTargetType;
    private final String methodName;
    private final ParameterizedType returnType;
    private final List<ByteCodeExpression> parameters;
    private final ImmutableList<ParameterizedType> parameterTypes;

    public static InvokeByteCodeExpression createInvoke(ByteCodeExpression instance, String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Iterable<? extends ByteCodeExpression> parameters) {
        return new InvokeByteCodeExpression(Objects.requireNonNull(instance, "instance is null"), instance.getType(), Objects.requireNonNull(methodName, "methodName is null"), Objects.requireNonNull(returnType, "returnType is null"), Objects.requireNonNull(parameterTypes, "parameterTypes is null"), Objects.requireNonNull(parameters, "parameters is null"));
    }

    public InvokeByteCodeExpression(@Nullable ByteCodeExpression instance, ParameterizedType methodTargetType, String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Iterable<? extends ByteCodeExpression> parameters) {
        super(Objects.requireNonNull(returnType, "returnType is null"));
        Preconditions.checkArgument((instance == null || !instance.getType().isPrimitive() ? 1 : 0) != 0, (String)"Type %s does not have methods", (Object[])new Object[]{this.getType()});
        this.instance = instance;
        this.methodTargetType = Objects.requireNonNull(methodTargetType, "methodTargetType is null");
        this.methodName = Objects.requireNonNull(methodName, "methodName is null");
        this.returnType = returnType;
        this.parameterTypes = ImmutableList.copyOf(Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
        this.parameters = ImmutableList.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        ByteCodeBlock block = new ByteCodeBlock();
        if (this.instance != null) {
            block.append(this.instance);
        }
        for (ByteCodeExpression parameter : this.parameters) {
            block.append(parameter);
        }
        if (this.instance == null) {
            return block.invokeStatic(this.methodTargetType, this.methodName, this.returnType, (Iterable<ParameterizedType>)this.parameterTypes);
        }
        if (this.instance.getType().isInterface()) {
            return block.invokeInterface(this.methodTargetType, this.methodName, this.returnType, (Iterable<ParameterizedType>)this.parameterTypes);
        }
        return block.invokeVirtual(this.methodTargetType, this.methodName, this.returnType, (Iterable<ParameterizedType>)this.parameterTypes);
    }

    @Override
    protected String formatOneLine() {
        if (this.instance == null) {
            return this.methodTargetType.getSimpleName() + "." + this.methodName + "(" + Joiner.on((String)", ").join(this.parameters) + ")";
        }
        return this.instance + "." + this.methodName + "(" + Joiner.on((String)", ").join(this.parameters) + ")";
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        ImmutableList.Builder children = ImmutableList.builder();
        if (this.instance != null) {
            children.add((Object)this.instance);
        }
        children.addAll(this.parameters);
        return children.build();
    }
}

