/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class InstanceOfByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;
    private final Class<?> type;

    public InstanceOfByteCodeExpression(ByteCodeExpression instance, Class<?> type) {
        super(ParameterizedType.type(Boolean.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public static ByteCodeExpression instanceOf(ByteCodeExpression instance, Class<?> type) {
        return new InstanceOfByteCodeExpression(instance, type);
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return new ByteCodeBlock().append(this.instance).isInstanceOf(this.type);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + " instanceof " + this.type;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

