/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ArrayOpCode;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class GetElementByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;
    private final ByteCodeExpression index;
    private final InstructionNode arrayLoadInstruction;

    public GetElementByteCodeExpression(ByteCodeExpression instance, ByteCodeExpression index) {
        super(instance.getType().getArrayComponentType());
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.index = Objects.requireNonNull(index, "index is null");
        Preconditions.checkArgument((index.getType().getPrimitiveType() == Integer.TYPE ? 1 : 0) != 0, (Object)("index must be int type, but is " + index.getType()));
        this.arrayLoadInstruction = ArrayOpCode.getArrayOpCode(instance.getType().getArrayComponentType()).getLoad();
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return new ByteCodeBlock().append(this.instance.getByteCode(generationContext)).append(this.index).append(this.arrayLoadInstruction);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + "[" + this.index + "]";
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.index);
    }
}

