/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.AndByteCodeExpression;
import com.facebook.presto.byteCode.expression.ArithmeticByteCodeExpression;
import com.facebook.presto.byteCode.expression.ArrayLengthByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ComparisonByteCodeExpression;
import com.facebook.presto.byteCode.expression.ConstantByteCodeExpression;
import com.facebook.presto.byteCode.expression.GetElementByteCodeExpression;
import com.facebook.presto.byteCode.expression.GetFieldByteCodeExpression;
import com.facebook.presto.byteCode.expression.InlineIfByteCodeExpression;
import com.facebook.presto.byteCode.expression.InvokeByteCodeExpression;
import com.facebook.presto.byteCode.expression.InvokeDynamicByteCodeExpression;
import com.facebook.presto.byteCode.expression.NegateByteCodeExpression;
import com.facebook.presto.byteCode.expression.NewArrayByteCodeExpression;
import com.facebook.presto.byteCode.expression.NewInstanceByteCodeExpression;
import com.facebook.presto.byteCode.expression.NotByteCodeExpression;
import com.facebook.presto.byteCode.expression.OrByteCodeExpression;
import com.facebook.presto.byteCode.expression.SetArrayElementByteCodeExpression;
import com.facebook.presto.byteCode.expression.SetFieldByteCodeExpression;
import com.facebook.presto.byteCode.instruction.Constant;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;

public final class ByteCodeExpressions {
    private ByteCodeExpressions() {
    }

    public static ByteCodeExpression constantTrue() {
        return new ConstantByteCodeExpression(Boolean.TYPE, Constant.loadBoolean(true));
    }

    public static ByteCodeExpression constantFalse() {
        return new ConstantByteCodeExpression(Boolean.TYPE, Constant.loadBoolean(false));
    }

    public static ByteCodeExpression constantBoolean(boolean value) {
        return new ConstantByteCodeExpression(Boolean.TYPE, Constant.loadBoolean(value));
    }

    public static ByteCodeExpression constantClass(Class<?> value) {
        return new ConstantByteCodeExpression(Class.class, Constant.loadClass(value));
    }

    public static ByteCodeExpression constantClass(ParameterizedType value) {
        return new ConstantByteCodeExpression(Class.class, Constant.loadClass(value));
    }

    public static ByteCodeExpression constantDouble(double value) {
        return new ConstantByteCodeExpression(Double.TYPE, Constant.loadDouble(value));
    }

    public static ByteCodeExpression constantFloat(float value) {
        return new ConstantByteCodeExpression(Float.TYPE, Constant.loadFloat(value));
    }

    public static ByteCodeExpression constantInt(int value) {
        return new ConstantByteCodeExpression(Integer.TYPE, Constant.loadInt(value));
    }

    public static ByteCodeExpression constantLong(long value) {
        return new ConstantByteCodeExpression(Long.TYPE, Constant.loadLong(value));
    }

    public static ByteCodeExpression constantNumber(Number value) {
        if (value instanceof Byte) {
            return ByteCodeExpressions.constantInt(value.intValue()).cast(Byte.TYPE);
        }
        if (value instanceof Short) {
            return ByteCodeExpressions.constantInt(value.intValue()).cast(Short.TYPE);
        }
        if (value instanceof Integer) {
            return ByteCodeExpressions.constantInt((Integer)value);
        }
        if (value instanceof Long) {
            return ByteCodeExpressions.constantLong((Long)value);
        }
        if (value instanceof Float) {
            return ByteCodeExpressions.constantFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return ByteCodeExpressions.constantDouble((Double)value);
        }
        throw new IllegalStateException("Unsupported number type " + value.getClass().getSimpleName());
    }

    public static ByteCodeExpression constantNull(Class<?> type) {
        return new ConstantByteCodeExpression(type, Constant.loadNull());
    }

    public static ByteCodeExpression constantNull(ParameterizedType type) {
        return new ConstantByteCodeExpression(type, Constant.loadNull());
    }

    public static ByteCodeExpression constantString(String value) {
        return new ConstantByteCodeExpression(String.class, Constant.loadString(value));
    }

    public static ByteCodeExpression defaultValue(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        if (type == Boolean.TYPE) {
            return ByteCodeExpressions.constantInt(0).cast(Boolean.TYPE);
        }
        if (type == Byte.TYPE) {
            return ByteCodeExpressions.constantInt(0).cast(Byte.TYPE);
        }
        if (type == Integer.TYPE) {
            return ByteCodeExpressions.constantInt(0);
        }
        if (type == Short.TYPE) {
            return ByteCodeExpressions.constantInt(0).cast(Short.TYPE);
        }
        if (type == Long.TYPE) {
            return ByteCodeExpressions.constantLong(0L);
        }
        if (type == Float.TYPE) {
            return ByteCodeExpressions.constantFloat(0.0f);
        }
        if (type == Double.TYPE) {
            return ByteCodeExpressions.constantDouble(0.0);
        }
        Preconditions.checkArgument((!type.isPrimitive() ? 1 : 0) != 0, (String)"Unsupported type %s", (Object[])new Object[]{type});
        return ByteCodeExpressions.constantNull(type);
    }

    public static ByteCodeExpression getStatic(Class<?> declaringClass, String name) {
        return new GetFieldByteCodeExpression(null, declaringClass, name);
    }

    public static ByteCodeExpression getStatic(Field staticField) {
        return new GetFieldByteCodeExpression(null, staticField);
    }

    public static ByteCodeExpression getStatic(FieldDefinition staticField) {
        return new GetFieldByteCodeExpression(null, staticField);
    }

    public static ByteCodeExpression getStatic(ParameterizedType declaringClass, String name, ParameterizedType type) {
        return new GetFieldByteCodeExpression(null, declaringClass, name, type);
    }

    public static ByteCodeExpression setStatic(Class<?> declaringClass, String name, ByteCodeExpression value) {
        return new SetFieldByteCodeExpression(null, declaringClass, name, value);
    }

    public static ByteCodeExpression setStatic(Field staticField, ByteCodeExpression value) {
        return new SetFieldByteCodeExpression(null, staticField, value);
    }

    public static ByteCodeExpression setStatic(FieldDefinition staticField, ByteCodeExpression value) {
        return new SetFieldByteCodeExpression(null, staticField, value);
    }

    public static ByteCodeExpression setStatic(ParameterizedType declaringClass, String name, ByteCodeExpression value) {
        return new SetFieldByteCodeExpression(null, declaringClass, name, value);
    }

    public static ByteCodeExpression newInstance(Class<?> returnType, ByteCodeExpression ... parameters) {
        return ByteCodeExpressions.newInstance(ParameterizedType.type(returnType), (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static ByteCodeExpression newInstance(Class<?> returnType, Iterable<? extends ByteCodeExpression> parameters) {
        return ByteCodeExpressions.newInstance(ParameterizedType.type(returnType), parameters);
    }

    public static ByteCodeExpression newInstance(ParameterizedType returnType, ByteCodeExpression ... parameters) {
        Objects.requireNonNull(parameters, "parameters is null");
        return ByteCodeExpressions.newInstance(returnType, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    public static ByteCodeExpression newInstance(ParameterizedType returnType, Iterable<? extends ByteCodeExpression> parameters) {
        Objects.requireNonNull(parameters, "parameters is null");
        return ByteCodeExpressions.newInstance(returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform(parameters, ByteCodeExpression::getType)), parameters);
    }

    public static ByteCodeExpression newInstance(Class<?> returnType, Iterable<? extends Class<?>> parameterTypes, ByteCodeExpression ... parameters) {
        return ByteCodeExpressions.newInstance(ParameterizedType.type(returnType), (Iterable<ParameterizedType>)Iterables.transform(parameterTypes, ParameterizedType::type), (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static ByteCodeExpression newInstance(ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, ByteCodeExpression ... parameters) {
        return ByteCodeExpressions.newInstance(returnType, parameterTypes, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static ByteCodeExpression newInstance(ParameterizedType type, Iterable<ParameterizedType> parameterTypes, Iterable<? extends ByteCodeExpression> parameters) {
        return new NewInstanceByteCodeExpression(type, parameterTypes, parameters);
    }

    public static ByteCodeExpression newArray(ParameterizedType type, int length) {
        return new NewArrayByteCodeExpression(type, length);
    }

    public static ByteCodeExpression newArray(ParameterizedType type, ByteCodeExpression length) {
        return new NewArrayByteCodeExpression(type, length);
    }

    public static ByteCodeExpression length(ByteCodeExpression instance) {
        return new ArrayLengthByteCodeExpression(instance);
    }

    public static ByteCodeExpression get(ByteCodeExpression instance, ByteCodeExpression index) {
        return new GetElementByteCodeExpression(instance, index);
    }

    public static ByteCodeExpression set(ByteCodeExpression instance, ByteCodeExpression index, ByteCodeExpression value) {
        return new SetArrayElementByteCodeExpression(instance, index, value);
    }

    public static ByteCodeExpression invokeStatic(MethodDefinition method, ByteCodeExpression ... parameters) {
        return ByteCodeExpressions.invokeStatic(method.getDeclaringClass().getType(), method.getName(), method.getReturnType(), (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    public static ByteCodeExpression invokeStatic(Method method, ByteCodeExpression ... parameters) {
        return ByteCodeExpressions.invokeStatic(method, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static ByteCodeExpression invokeStatic(Method method, Iterable<? extends ByteCodeExpression> parameters) {
        return ByteCodeExpressions.invokeStatic(method.getDeclaringClass(), method.getName(), method.getReturnType(), parameters);
    }

    public static ByteCodeExpression invokeStatic(Class<?> methodTargetType, String methodName, Class<?> returnType, ByteCodeExpression ... parameters) {
        return ByteCodeExpressions.invokeStatic(methodTargetType, methodName, returnType, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static ByteCodeExpression invokeStatic(Class<?> methodTargetType, String methodName, Class<?> returnType, Iterable<? extends ByteCodeExpression> parameters) {
        return ByteCodeExpressions.invokeStatic(ParameterizedType.type(methodTargetType), methodName, ParameterizedType.type(returnType), parameters);
    }

    public static ByteCodeExpression invokeStatic(ParameterizedType methodTargetType, String methodName, ParameterizedType returnType, Iterable<? extends ByteCodeExpression> parameters) {
        Objects.requireNonNull(methodTargetType, "methodTargetType is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(parameters, "parameters is null");
        return ByteCodeExpressions.invokeStatic(methodTargetType, methodName, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform(parameters, ByteCodeExpression::getType)), parameters);
    }

    public static ByteCodeExpression invokeStatic(Class<?> methodTargetType, String methodName, Class<?> returnType, Iterable<? extends Class<?>> parameterTypes, ByteCodeExpression ... parameters) {
        Objects.requireNonNull(methodTargetType, "methodTargetType is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(parameterTypes, "parameterTypes is null");
        Objects.requireNonNull(parameters, "parameters is null");
        return ByteCodeExpressions.invokeStatic(ParameterizedType.type(methodTargetType), methodName, ParameterizedType.type(returnType), (Iterable<ParameterizedType>)Iterables.transform(parameterTypes, ParameterizedType::type), (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    public static ByteCodeExpression invokeStatic(ParameterizedType methodTargetType, String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, ByteCodeExpression ... parameters) {
        return ByteCodeExpressions.invokeStatic(methodTargetType, methodName, returnType, parameterTypes, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static ByteCodeExpression invokeStatic(ParameterizedType methodTargetType, String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Iterable<? extends ByteCodeExpression> parameters) {
        return new InvokeByteCodeExpression(null, methodTargetType, methodName, returnType, parameterTypes, parameters);
    }

    public static ByteCodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, Class<?> returnType, ByteCodeExpression ... parameters) {
        return ByteCodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, returnType, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static ByteCodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, Class<?> returnType, Iterable<? extends ByteCodeExpression> parameters) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(parameters, "parameters is null");
        return ByteCodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, ParameterizedType.type(returnType), (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform(parameters, ByteCodeExpression::getType)), parameters);
    }

    public static ByteCodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, ParameterizedType returnType, ByteCodeExpression ... parameters) {
        return ByteCodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, returnType, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static ByteCodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, ParameterizedType returnType, Iterable<? extends ByteCodeExpression> parameters) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(parameters, "parameters is null");
        return ByteCodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform(parameters, ByteCodeExpression::getType)), parameters);
    }

    public static ByteCodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, MethodType methodType, ByteCodeExpression ... parameters) {
        Objects.requireNonNull(methodType, "methodType is null");
        Objects.requireNonNull(parameters, "parameters is null");
        return ByteCodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, methodType, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    public static ByteCodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, MethodType methodType, Iterable<? extends ByteCodeExpression> parameters) {
        return ByteCodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, ParameterizedType.type(methodType.returnType()), Iterables.transform(methodType.parameterList(), ParameterizedType::type), (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf(Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static ByteCodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Iterable<? extends ByteCodeExpression> parameters) {
        return new InvokeDynamicByteCodeExpression(bootstrapMethod, bootstrapArgs, methodName, returnType, parameters, parameterTypes);
    }

    public static ByteCodeExpression add(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.IADD, left, right);
    }

    public static ByteCodeExpression subtract(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.ISUB, left, right);
    }

    public static ByteCodeExpression multiply(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.IMUL, left, right);
    }

    public static ByteCodeExpression divide(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.IDIV, left, right);
    }

    public static ByteCodeExpression remainder(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.IREM, left, right);
    }

    public static ByteCodeExpression bitwiseAnd(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.IAND, left, right);
    }

    public static ByteCodeExpression bitwiseOr(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.IOR, left, right);
    }

    public static ByteCodeExpression bitwiseXor(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.IXOR, left, right);
    }

    public static ByteCodeExpression shiftLeft(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.ISHL, left, right);
    }

    public static ByteCodeExpression shiftRight(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.ISHR, left, right);
    }

    public static ByteCodeExpression shiftRightUnsigned(ByteCodeExpression left, ByteCodeExpression right) {
        return ArithmeticByteCodeExpression.createArithmeticByteCodeExpression(OpCode.IUSHR, left, right);
    }

    public static ByteCodeExpression negate(ByteCodeExpression value) {
        return new NegateByteCodeExpression(value);
    }

    public static ByteCodeExpression lessThan(ByteCodeExpression left, ByteCodeExpression right) {
        return ComparisonByteCodeExpression.lessThan(left, right);
    }

    public static ByteCodeExpression greaterThan(ByteCodeExpression left, ByteCodeExpression right) {
        return ComparisonByteCodeExpression.greaterThan(left, right);
    }

    public static ByteCodeExpression lessThanOrEqual(ByteCodeExpression left, ByteCodeExpression right) {
        return ComparisonByteCodeExpression.lessThanOrEqual(left, right);
    }

    public static ByteCodeExpression greaterThanOrEqual(ByteCodeExpression left, ByteCodeExpression right) {
        return ComparisonByteCodeExpression.greaterThanOrEqual(left, right);
    }

    public static ByteCodeExpression equal(ByteCodeExpression left, ByteCodeExpression right) {
        return ComparisonByteCodeExpression.equal(left, right);
    }

    public static ByteCodeExpression notEqual(ByteCodeExpression left, ByteCodeExpression right) {
        return ComparisonByteCodeExpression.notEqual(left, right);
    }

    public static ByteCodeExpression and(ByteCodeExpression left, ByteCodeExpression right) {
        return new AndByteCodeExpression(left, right);
    }

    public static ByteCodeExpression or(ByteCodeExpression left, ByteCodeExpression right) {
        return new OrByteCodeExpression(left, right);
    }

    public static ByteCodeExpression not(ByteCodeExpression value) {
        return new NotByteCodeExpression(value);
    }

    public static ByteCodeExpression inlineIf(ByteCodeExpression condition, ByteCodeExpression ifTrue, ByteCodeExpression ifFalse) {
        return new InlineIfByteCodeExpression(condition, ifTrue, ifFalse);
    }

    public static ByteCodeExpression print(ByteCodeExpression variable) {
        ByteCodeExpression out = ByteCodeExpressions.getStatic(System.class, "out");
        return out.invoke("println", Void.TYPE, variable);
    }
}

