/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ArrayLengthByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.expression.CastByteCodeExpression;
import com.facebook.presto.byteCode.expression.GetElementByteCodeExpression;
import com.facebook.presto.byteCode.expression.GetFieldByteCodeExpression;
import com.facebook.presto.byteCode.expression.InstanceOfByteCodeExpression;
import com.facebook.presto.byteCode.expression.InvokeByteCodeExpression;
import com.facebook.presto.byteCode.expression.PopByteCodeExpression;
import com.facebook.presto.byteCode.expression.ReturnByteCodeExpression;
import com.facebook.presto.byteCode.expression.SetArrayElementByteCodeExpression;
import com.facebook.presto.byteCode.expression.SetFieldByteCodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public abstract class ByteCodeExpression
implements ByteCodeNode {
    private final ParameterizedType type;

    protected ByteCodeExpression(ParameterizedType type) {
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public final ParameterizedType getType() {
        return this.type;
    }

    public abstract ByteCodeNode getByteCode(MethodGenerationContext var1);

    protected abstract String formatOneLine();

    public final String toString() {
        return this.formatOneLine() + (this.type.getPrimitiveType() == Void.TYPE ? ";" : "");
    }

    public final ByteCodeExpression getField(Class<?> declaringClass, String name) {
        return new GetFieldByteCodeExpression(this, declaringClass, name);
    }

    public final ByteCodeExpression getField(String name, Class<?> type) {
        return new GetFieldByteCodeExpression(this, this.getType(), name, ParameterizedType.type(type));
    }

    public final ByteCodeExpression getField(Field field) {
        return new GetFieldByteCodeExpression(this, field);
    }

    public final ByteCodeExpression getField(FieldDefinition field) {
        return new GetFieldByteCodeExpression(this, field);
    }

    public final ByteCodeExpression getField(ParameterizedType declaringClass, String name, ParameterizedType type) {
        return new GetFieldByteCodeExpression(this, declaringClass, name, type);
    }

    public final ByteCodeExpression setField(String name, ByteCodeExpression value) {
        return new SetFieldByteCodeExpression(this, this.getType(), name, value);
    }

    public final ByteCodeExpression setField(Field field, ByteCodeExpression value) {
        return new SetFieldByteCodeExpression(this, field, value);
    }

    public final ByteCodeExpression setField(FieldDefinition field, ByteCodeExpression value) {
        return new SetFieldByteCodeExpression(this, field, value);
    }

    public final ByteCodeExpression cast(Class<?> type) {
        return new CastByteCodeExpression(this, ParameterizedType.type(type));
    }

    public final ByteCodeExpression cast(ParameterizedType type) {
        return new CastByteCodeExpression(this, type);
    }

    public final ByteCodeExpression invoke(Method method, ByteCodeExpression ... parameters) {
        return this.invoke(method, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public final ByteCodeExpression invoke(MethodDefinition method, Iterable<? extends ByteCodeExpression> parameters) {
        ImmutableList params = ImmutableList.copyOf(parameters);
        Preconditions.checkArgument((method.getParameters().size() == params.size() ? 1 : 0) != 0, (String)"Expected %s params found %s", (Object[])new Object[]{method.getParameters().size(), params.size()});
        return this.invoke(method.getName(), method.getReturnType(), parameters);
    }

    public final ByteCodeExpression invoke(Method method, Iterable<? extends ByteCodeExpression> parameters) {
        return this.invoke(method.getName(), ParameterizedType.type(method.getReturnType()), parameters);
    }

    public final ByteCodeExpression invoke(String methodName, Class<?> returnType, ByteCodeExpression ... parameters) {
        return this.invoke(methodName, ParameterizedType.type(returnType), (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public final ByteCodeExpression invoke(String methodName, Class<?> returnType, Iterable<? extends ByteCodeExpression> parameters) {
        return this.invoke(methodName, ParameterizedType.type(returnType), parameters);
    }

    public final ByteCodeExpression invoke(String methodName, ParameterizedType returnType, Iterable<? extends ByteCodeExpression> parameters) {
        Objects.requireNonNull(parameters, "parameters is null");
        return this.invoke(methodName, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform(parameters, ByteCodeExpression::getType)), parameters);
    }

    public final ByteCodeExpression invoke(String methodName, Class<?> returnType, Iterable<? extends Class<?>> parameterTypes, ByteCodeExpression ... parameters) {
        return this.invoke(methodName, ParameterizedType.type(returnType), (Iterable<ParameterizedType>)Iterables.transform(parameterTypes, ParameterizedType::type), (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public final ByteCodeExpression invoke(String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, ByteCodeExpression ... parameters) {
        return this.invoke(methodName, returnType, parameterTypes, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public final ByteCodeExpression invoke(String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Iterable<? extends ByteCodeExpression> parameters) {
        return InvokeByteCodeExpression.createInvoke(this, methodName, returnType, parameterTypes, parameters);
    }

    public final ByteCodeExpression getElement(int index) {
        return new GetElementByteCodeExpression(this, ByteCodeExpressions.constantInt(index));
    }

    public final ByteCodeExpression getElement(ByteCodeExpression index) {
        return new GetElementByteCodeExpression(this, index);
    }

    public final ByteCodeExpression setElement(int index, ByteCodeExpression value) {
        return new SetArrayElementByteCodeExpression(this, ByteCodeExpressions.constantInt(index), value);
    }

    public final ByteCodeExpression setElement(ByteCodeExpression index, ByteCodeExpression value) {
        return new SetArrayElementByteCodeExpression(this, index, value);
    }

    public final ByteCodeExpression length() {
        return new ArrayLengthByteCodeExpression(this);
    }

    public final ByteCodeExpression ret() {
        return new ReturnByteCodeExpression(this);
    }

    public final ByteCodeExpression pop() {
        if (this.getType().getPrimitiveType() == Void.TYPE) {
            return this;
        }
        return new PopByteCodeExpression(this);
    }

    @Override
    public final void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        this.getByteCode(generationContext).accept(visitor, generationContext);
    }

    @Override
    public final <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitByteCodeExpression(parent, this);
    }

    public ByteCodeExpression instanceOf(Class<?> type) {
        return InstanceOfByteCodeExpression.instanceOf(this, type);
    }
}

