/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class ArrayLengthByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;

    public ArrayLengthByteCodeExpression(ByteCodeExpression instance) {
        super(ParameterizedType.type(Integer.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return new ByteCodeBlock().append(this.instance.getByteCode(generationContext)).append(OpCode.ARRAYLENGTH);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + ".length";
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

