/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.control;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.control.FlowControl;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class IfStatement
implements FlowControl {
    private final String comment;
    private final ByteCodeBlock condition = new ByteCodeBlock();
    private final ByteCodeBlock ifTrue = new ByteCodeBlock();
    private final ByteCodeBlock ifFalse = new ByteCodeBlock();
    private final LabelNode falseLabel = new LabelNode("false");
    private final LabelNode outLabel = new LabelNode("out");

    public IfStatement() {
        this.comment = null;
    }

    public IfStatement(String format, Object ... args) {
        this.comment = String.format(format, args);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public ByteCodeBlock condition() {
        return this.condition;
    }

    public IfStatement condition(ByteCodeNode node) {
        Preconditions.checkState((boolean)this.condition.isEmpty(), (Object)"condition already set");
        this.condition.append(node);
        return this;
    }

    public ByteCodeBlock ifTrue() {
        return this.ifTrue;
    }

    public IfStatement ifTrue(ByteCodeNode node) {
        Preconditions.checkState((boolean)this.ifTrue.isEmpty(), (Object)"ifTrue already set");
        this.ifTrue.append(node);
        return this;
    }

    public ByteCodeBlock ifFalse() {
        return this.ifFalse;
    }

    public IfStatement ifFalse(ByteCodeNode node) {
        Preconditions.checkState((boolean)this.ifFalse.isEmpty(), (Object)"ifFalse already set");
        this.ifFalse.append(node);
        return this;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        Preconditions.checkState((!this.condition.isEmpty() ? 1 : 0) != 0, (Object)"IfStatement does not have a condition set");
        Preconditions.checkState((!this.ifTrue.isEmpty() || !this.ifFalse.isEmpty() ? 1 : 0) != 0, (Object)"IfStatement does not have a true or false block set");
        ByteCodeBlock block = new ByteCodeBlock();
        block.append(new ByteCodeBlock().setDescription("condition").append(this.condition));
        block.ifFalseGoto(this.falseLabel);
        if (!this.ifTrue.isEmpty()) {
            block.append(new ByteCodeBlock().setDescription("ifTrue").append(this.ifTrue));
        }
        if (!this.ifFalse.isEmpty()) {
            block.gotoLabel(this.outLabel);
            block.visitLabel(this.falseLabel);
            block.append(new ByteCodeBlock().setDescription("ifFalse").append(this.ifFalse));
            block.visitLabel(this.outLabel);
        } else {
            block.visitLabel(this.falseLabel);
        }
        block.accept(visitor, generationContext);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.condition, (Object)this.ifTrue, (Object)this.ifFalse);
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitIf(parent, this);
    }
}

