/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.VariableInstruction;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class Variable
extends ByteCodeExpression {
    private final String name;

    public Variable(String name, ParameterizedType type) {
        super(type);
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public String getName() {
        return this.name;
    }

    public ByteCodeExpression set(ByteCodeExpression value) {
        return new SetVariableByteCodeExpression(this, value);
    }

    public ByteCodeExpression increment() {
        return new SetVariableByteCodeExpression(this, ByteCodeExpressions.add(this, ByteCodeExpressions.constantInt(1)));
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return VariableInstruction.loadVariable(this);
    }

    @Override
    protected String formatOneLine() {
        return this.name;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    private static final class SetVariableByteCodeExpression
    extends ByteCodeExpression {
        private final Variable variable;
        private final ByteCodeExpression value;

        public SetVariableByteCodeExpression(Variable variable, ByteCodeExpression value) {
            super(ParameterizedType.type(Void.TYPE));
            this.variable = Objects.requireNonNull(variable, "variable is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        @Override
        public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
            return new ByteCodeBlock().append(this.value).putVariable(this.variable);
        }

        @Override
        public List<ByteCodeNode> getChildNodes() {
            return ImmutableList.of((Object)this.value);
        }

        @Override
        protected String formatOneLine() {
            return this.variable.getName() + " = " + this.value;
        }
    }
}

