/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.IntervalDayTimeType;
import com.facebook.presto.spi.type.IntervalYearMonthType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.ArrayParametricType;
import com.facebook.presto.type.ColorType;
import com.facebook.presto.type.FunctionParametricType;
import com.facebook.presto.type.JsonPathType;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.MapParametricType;
import com.facebook.presto.type.ParametricType;
import com.facebook.presto.type.RegexpType;
import com.facebook.presto.type.RowParametricType;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class TypeRegistry
implements TypeManager {
    private final ConcurrentMap<TypeSignature, Type> types = new ConcurrentHashMap<TypeSignature, Type>();
    private final ConcurrentMap<String, ParametricType> parametricTypes = new ConcurrentHashMap<String, ParametricType>();

    public TypeRegistry() {
        this((Set<Type>)ImmutableSet.of());
    }

    @Inject
    public TypeRegistry(Set<Type> types) {
        Objects.requireNonNull(types, "types is null");
        this.types.put(UnknownType.UNKNOWN.getTypeSignature(), (Type)UnknownType.UNKNOWN);
        this.addType((Type)BooleanType.BOOLEAN);
        this.addType((Type)BigintType.BIGINT);
        this.addType((Type)DoubleType.DOUBLE);
        this.addType((Type)VarcharType.VARCHAR);
        this.addType((Type)VarbinaryType.VARBINARY);
        this.addType((Type)DateType.DATE);
        this.addType((Type)TimeType.TIME);
        this.addType((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        this.addType((Type)TimestampType.TIMESTAMP);
        this.addType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        this.addType((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        this.addType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME);
        this.addType((Type)HyperLogLogType.HYPER_LOG_LOG);
        this.addType((Type)RegexpType.REGEXP);
        this.addType((Type)LikePatternType.LIKE_PATTERN);
        this.addType((Type)JsonPathType.JSON_PATH);
        this.addType((Type)ColorType.COLOR);
        this.addType((Type)JsonType.JSON);
        this.addParametricType(RowParametricType.ROW);
        this.addParametricType(ArrayParametricType.ARRAY);
        this.addParametricType(MapParametricType.MAP);
        this.addParametricType(FunctionParametricType.FUNCTION);
        for (Type type : types) {
            this.addType(type);
        }
    }

    public Type getType(TypeSignature signature) {
        Type type = (Type)this.types.get(signature);
        if (type == null) {
            return this.instantiateParametricType(signature);
        }
        return type;
    }

    public Type getParameterizedType(String baseTypeName, List<TypeSignature> typeParameters, List<Object> literalParameters) {
        return this.getType(new TypeSignature(baseTypeName, typeParameters, literalParameters));
    }

    private Type instantiateParametricType(TypeSignature signature) {
        ImmutableList.Builder parameterTypes = ImmutableList.builder();
        for (TypeSignature parameter : signature.getParameters()) {
            Type parameterType = this.getType(parameter);
            if (parameterType == null) {
                return null;
            }
            parameterTypes.add((Object)parameterType);
        }
        ParametricType parametricType = (ParametricType)this.parametricTypes.get(signature.getBase().toLowerCase(Locale.ENGLISH));
        if (parametricType == null) {
            return null;
        }
        Type instantiatedType = parametricType.createType((List<Type>)parameterTypes.build(), signature.getLiteralParameters());
        Preconditions.checkState((boolean)instantiatedType.getTypeSignature().equals((Object)signature), (String)"Instantiated parametric type name (%s) does not match expected name (%s)", (Object[])new Object[]{instantiatedType, signature});
        return instantiatedType;
    }

    public List<Type> getTypes() {
        return ImmutableList.copyOf(this.types.values());
    }

    public void addType(Type type) {
        TypeRegistry.verifyTypeClass(type);
        Type existingType = this.types.putIfAbsent(type.getTypeSignature(), type);
        Preconditions.checkState((existingType == null || existingType.equals(type) ? 1 : 0) != 0, (String)"Type %s is already registered", (Object[])new Object[]{type});
    }

    public void addParametricType(ParametricType parametricType) {
        String name = parametricType.getName().toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!this.parametricTypes.containsKey(name) ? 1 : 0) != 0, (String)"Parametric type already registered: %s", (Object[])new Object[]{name});
        this.parametricTypes.putIfAbsent(name, parametricType);
    }

    public static void verifyTypeClass(Type type) {
        Objects.requireNonNull(type, "type is null");
    }
}

