/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.operator.scalar.RowFieldReference;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ParametricType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public final class RowParametricType
implements ParametricType {
    public static final RowParametricType ROW = new RowParametricType();

    private RowParametricType() {
    }

    @Override
    public String getName() {
        return "row";
    }

    public RowType createType(List<Type> types, List<Object> literals) {
        Preconditions.checkArgument((!types.isEmpty() ? 1 : 0) != 0, (Object)"types is empty");
        if (literals.isEmpty()) {
            return new RowType(types, Optional.empty());
        }
        Preconditions.checkArgument((types.size() == literals.size() ? 1 : 0) != 0, (Object)"types and literals must be matched in size");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object literal : literals) {
            builder.add((Object)Types.checkType(literal, String.class, "literal"));
        }
        return new RowType(types, Optional.of(builder.build()));
    }

    public List<SqlFunction> createFunctions(Type type) {
        RowType rowType = Types.checkType(type, RowType.class, "type");
        ImmutableList.Builder builder = ImmutableList.builder();
        List<RowType.RowField> fields = rowType.getFields();
        int i = 0;
        while (i < fields.size()) {
            RowType.RowField field = fields.get(i);
            int index = i++;
            field.getName().ifPresent(name -> builder.add((Object)new RowFieldReference(rowType, field.getType(), index, field.getName().get())));
        }
        return builder.build();
    }
}

