/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExchangeNode
extends PlanNode {
    private final Type type;
    private final List<Symbol> outputs;
    private final List<PlanNode> sources;
    private final Optional<List<Symbol>> partitionKeys;
    private final Optional<Symbol> hashSymbol;
    private final List<List<Symbol>> inputs;

    @JsonCreator
    public ExchangeNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="partitionKeys") Optional<List<Symbol>> partitionKeys, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="outputs") List<Symbol> outputs, @JsonProperty(value="inputs") List<List<Symbol>> inputs) {
        super(id);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        Objects.requireNonNull(outputs, "outputs is null");
        Objects.requireNonNull(inputs, "inputs is null");
        partitionKeys.ifPresent(list -> Preconditions.checkArgument((boolean)outputs.containsAll((Collection<?>)list), (Object)"outputs must contain all partitionKeys"));
        Preconditions.checkArgument((!hashSymbol.isPresent() || outputs.contains(hashSymbol.get()) ? 1 : 0) != 0, (Object)"outputs must contain hashSymbol");
        Preconditions.checkArgument((boolean)inputs.stream().allMatch(inputSymbols -> inputSymbols.size() == outputs.size()), (Object)"Input symbols do not match output symbols");
        Preconditions.checkArgument((inputs.size() == sources.size() ? 1 : 0) != 0, (Object)"Must have same number of input lists as sources");
        for (int i = 0; i < inputs.size(); ++i) {
            Preconditions.checkArgument((boolean)sources.get(i).getOutputSymbols().containsAll((Collection)inputs.get(i)), (Object)"Source does not supply all required input symbols");
        }
        this.type = type;
        this.sources = sources;
        this.partitionKeys = partitionKeys.map(ImmutableList::copyOf);
        this.hashSymbol = hashSymbol;
        this.outputs = ImmutableList.copyOf(outputs);
        this.inputs = ImmutableList.copyOf(inputs);
    }

    public static ExchangeNode partitionedExchangeNullReplicate(PlanNodeId id, PlanNode child, Symbol partitionKey, Optional<Symbol> hashSymbol) {
        return new ExchangeNode(id, Type.REPARTITION_WITH_NULL_REPLICATION, Optional.of(ImmutableList.of((Object)partitionKey)), hashSymbol, (List<PlanNode>)ImmutableList.of((Object)child), child.getOutputSymbols(), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, PlanNode child, Optional<List<Symbol>> partitionKeys, Optional<Symbol> hashSymbol) {
        return new ExchangeNode(id, Type.REPARTITION, partitionKeys, hashSymbol, (List<PlanNode>)ImmutableList.of((Object)child), child.getOutputSymbols(), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode gatheringExchange(PlanNodeId id, PlanNode child) {
        return new ExchangeNode(id, Type.GATHER, Optional.empty(), Optional.empty(), (List<PlanNode>)ImmutableList.of((Object)child), child.getOutputSymbols(), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty
    public Optional<List<Symbol>> getPartitionKeys() {
        return this.partitionKeys;
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty
    public List<List<Symbol>> getInputs() {
        return this.inputs;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitExchange(this, context);
    }

    public static enum Type {
        GATHER,
        REPARTITION,
        REPARTITION_WITH_NULL_REPLICATION,
        REPLICATE;

    }
}

