/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimplifyExpressions
extends PlanOptimizer {
    private final Metadata metadata;
    private final SqlParser sqlParser;

    public SimplifyExpressions(Metadata metadata, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(this.metadata, this.sqlParser, session, types, idAllocator), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final Session session;
        private final Map<Symbol, Type> types;
        private final PlanNodeIdAllocator idAllocator;

        public Rewriter(Metadata metadata, SqlParser sqlParser, Session session, Map<Symbol, Type> types, PlanNodeIdAllocator idAllocator) {
            this.metadata = metadata;
            this.sqlParser = sqlParser;
            this.session = session;
            this.types = types;
            this.idAllocator = idAllocator;
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap assignments = ImmutableMap.copyOf((Map)Maps.transformValues(node.getAssignments(), this::simplifyExpression));
            return new ProjectNode(node.getId(), source, (Map<Symbol, Expression>)assignments);
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            Expression simplified = this.simplifyExpression(node.getPredicate());
            if (simplified.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return source;
            }
            if (simplified.equals((Object)BooleanLiteral.FALSE_LITERAL) || simplified instanceof NullLiteral) {
                return new ValuesNode(this.idAllocator.getNextId(), node.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of());
            }
            return new FilterNode(node.getId(), source, simplified);
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Expression originalConstraint = null;
            if (node.getOriginalConstraint() != null) {
                originalConstraint = this.simplifyExpression(node.getOriginalConstraint());
            }
            return new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), node.getLayout(), node.getCurrentConstraint(), originalConstraint);
        }

        private Expression simplifyExpression(Expression input) {
            IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.types, input);
            ExpressionInterpreter interpreter = ExpressionInterpreter.expressionOptimizer(input, this.metadata, this.session, expressionTypes);
            return LiteralInterpreter.toExpression(interpreter.optimize(NoOpSymbolResolver.INSTANCE), expressionTypes.get(input));
        }
    }
}

