/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionNodeInliner;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PruneRedundantProjections
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(), plan).getPlanNode();
    }

    private static class Rewriter
    extends PlanRewriter<Void, Map<Symbol, Expression>> {
        private Rewriter() {
        }

        @Override
        protected PlanRewriter.Result<Map<Symbol, Expression>> visitPlan(PlanNode node, PlanRewriter.RewriteContext<Void, Map<Symbol, Expression>> context) {
            return context.defaultRewrite(node, assignments -> assignments.stream().flatMap(assignment -> assignment.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        @Override
        public PlanRewriter.Result<Map<Symbol, Expression>> visitProject(ProjectNode node, PlanRewriter.RewriteContext<Void, Map<Symbol, Expression>> context) {
            Expression expanded;
            PlanRewriter.Result<Map<Symbol, Expression>> result = context.rewrite(node.getSource());
            Map<QualifiedNameReference, Expression> sourceExpandedExpressions = result.getPayload().entrySet().stream().collect(Collectors.toMap(entry -> ((Symbol)entry.getKey()).toQualifiedNameReference(), Map.Entry::getValue));
            ImmutableMap.Builder expandedExpressions = ImmutableMap.builder().putAll(result.getPayload());
            HashMap<Expression, Object> computedExpressions = new HashMap<Expression, Object>();
            ImmutableMap.Builder newAssignments = ImmutableMap.builder();
            for (Symbol symbol : result.getPlanNode().getOutputSymbols()) {
                expanded = result.getPayload().get(symbol);
                if (expanded == null) continue;
                computedExpressions.putIfAbsent(expanded, symbol.toQualifiedNameReference());
            }
            for (Map.Entry entry2 : node.getAssignments().entrySet()) {
                if (!DeterminismEvaluator.isDeterministic((Expression)entry2.getValue())) {
                    newAssignments.put(entry2.getKey(), entry2.getValue());
                    continue;
                }
                expanded = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionNodeInliner(sourceExpandedExpressions), (Expression)((Expression)entry2.getValue()));
                if (!((Symbol)entry2.getKey()).toQualifiedNameReference().equals(entry2.getValue())) {
                    expandedExpressions.put(entry2.getKey(), (Object)expanded);
                }
                Expression previousExpression = (Expression)computedExpressions.putIfAbsent(expanded, entry2.getValue());
                newAssignments.put(entry2.getKey(), (Object)(previousExpression == null ? (Expression)entry2.getValue() : previousExpression));
            }
            return new PlanRewriter.Result<ImmutableMap>(new ProjectNode(node.getId(), result.getPlanNode(), (Map<Symbol, Expression>)newAssignments.build()), expandedExpressions.build());
        }
    }
}

