/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProjectionPushDown
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, symbolAllocator), plan);
    }

    private static Map<Symbol, QualifiedNameReference> extractExchangeOutputToInput(ExchangeNode exchange, int sourceIndex) {
        HashMap<Symbol, QualifiedNameReference> outputToInputMap = new HashMap<Symbol, QualifiedNameReference>();
        for (int i = 0; i < exchange.getOutputSymbols().size(); ++i) {
            outputToInputMap.put(exchange.getOutputSymbols().get(i), exchange.getInputs().get(sourceIndex).get(i).toQualifiedNameReference());
        }
        return outputToInputMap;
    }

    private static Expression translateExpression(Expression inputExpression, Map<Symbol, QualifiedNameReference> symbolMapping) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(symbolMapping), (Expression)inputExpression);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;

        public Rewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            if (source instanceof UnionNode) {
                return this.pushProjectionThrough(node, (UnionNode)source);
            }
            if (source instanceof ExchangeNode) {
                return this.pushProjectionThrough(node, (ExchangeNode)source);
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
        }

        private PlanNode pushProjectionThrough(ProjectNode node, UnionNode source) {
            List<Symbol> outputLayout = node.getOutputSymbols();
            ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
            ImmutableList.Builder outputSources = ImmutableList.builder();
            for (int i = 0; i < source.getSources().size(); ++i) {
                Map<Symbol, QualifiedNameReference> outputToInput = source.sourceSymbolMap(i);
                ImmutableMap.Builder assignments = ImmutableMap.builder();
                HashMap<Symbol, Symbol> projectSymbolMapping = new HashMap<Symbol, Symbol>();
                for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                    Expression translatedExpression = ProjectionPushDown.translateExpression(entry.getValue(), outputToInput);
                    Type type = this.symbolAllocator.getTypes().get(entry.getKey());
                    Symbol symbol2 = this.symbolAllocator.newSymbol(translatedExpression, type);
                    assignments.put((Object)symbol2, (Object)translatedExpression);
                    projectSymbolMapping.put(entry.getKey(), symbol2);
                }
                outputSources.add((Object)new ProjectNode(this.idAllocator.getNextId(), source.getSources().get(i), (Map<Symbol, Expression>)assignments.build()));
                outputLayout.forEach(symbol -> mappings.put(symbol, projectSymbolMapping.get(symbol)));
            }
            return new UnionNode(node.getId(), (List<PlanNode>)outputSources.build(), (ListMultimap<Symbol, Symbol>)mappings.build());
        }

        private PlanNode pushProjectionThrough(ProjectNode node, ExchangeNode exchange) {
            ImmutableList.Builder newSourceBuilder = ImmutableList.builder();
            ImmutableList.Builder inputsBuilder = ImmutableList.builder();
            for (int i = 0; i < exchange.getSources().size(); ++i) {
                Map outputToInputMap = ProjectionPushDown.extractExchangeOutputToInput(exchange, i);
                LinkedHashMap<Symbol, Expression> projections = new LinkedHashMap<Symbol, Expression>();
                ImmutableList.Builder inputs = ImmutableList.builder();
                if (exchange.getPartitionKeys().isPresent()) {
                    exchange.getPartitionKeys().get().stream().map(outputToInputMap::get).forEach(nameReference -> {
                        Symbol symbol = Symbol.fromQualifiedName(nameReference.getName());
                        projections.put(symbol, (Expression)nameReference);
                        inputs.add((Object)symbol);
                    });
                }
                if (exchange.getHashSymbol().isPresent()) {
                    projections.put(exchange.getHashSymbol().get(), (Expression)exchange.getHashSymbol().get().toQualifiedNameReference());
                    inputs.add((Object)exchange.getHashSymbol().get());
                }
                for (Map.Entry<Symbol, Expression> projection : node.getAssignments().entrySet()) {
                    Expression translatedExpression = ProjectionPushDown.translateExpression(projection.getValue(), outputToInputMap);
                    Type type = this.symbolAllocator.getTypes().get(projection.getKey());
                    Symbol symbol = this.symbolAllocator.newSymbol(translatedExpression, type);
                    projections.put(symbol, translatedExpression);
                    inputs.add((Object)symbol);
                }
                newSourceBuilder.add((Object)new ProjectNode(this.idAllocator.getNextId(), exchange.getSources().get(i), projections));
                inputsBuilder.add((Object)inputs.build());
            }
            ImmutableList.Builder outputBuilder = ImmutableList.builder();
            if (exchange.getPartitionKeys().isPresent()) {
                exchange.getPartitionKeys().get().stream().forEach(arg_0 -> ((ImmutableList.Builder)outputBuilder).add(arg_0));
            }
            if (exchange.getHashSymbol().isPresent()) {
                outputBuilder.add((Object)exchange.getHashSymbol().get());
            }
            for (Map.Entry<Symbol, Expression> projection : node.getAssignments().entrySet()) {
                outputBuilder.add((Object)projection.getKey());
            }
            return new ExchangeNode(exchange.getId(), exchange.getType(), exchange.getPartitionKeys(), exchange.getHashSymbol(), (List<PlanNode>)newSourceBuilder.build(), (List<Symbol>)outputBuilder.build(), (List<List<Symbol>>)inputsBuilder.build());
        }
    }
}

