/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PlanFragment {
    private final PlanFragmentId id;
    private final PlanNode root;
    private final Map<Symbol, Type> symbols;
    private final List<Symbol> outputLayout;
    private final PlanDistribution distribution;
    private final PlanNodeId partitionedSource;
    private final List<Type> types;
    private final PlanNode partitionedSourceNode;
    private final List<RemoteSourceNode> remoteSourceNodes;
    private final OutputPartitioning outputPartitioning;
    private final Optional<List<Symbol>> partitionBy;
    private final Optional<NullPartitioning> nullPartitionPolicy;
    private final Optional<Symbol> hash;

    @JsonCreator
    public PlanFragment(@JsonProperty(value="id") PlanFragmentId id, @JsonProperty(value="root") PlanNode root, @JsonProperty(value="symbols") Map<Symbol, Type> symbols, @JsonProperty(value="outputLayout") List<Symbol> outputLayout, @JsonProperty(value="distribution") PlanDistribution distribution, @JsonProperty(value="partitionedSource") PlanNodeId partitionedSource, @JsonProperty(value="outputPartitioning") OutputPartitioning outputPartitioning, @JsonProperty(value="partitionBy") Optional<List<Symbol>> partitionBy, @JsonProperty(value="nullPartitionPolicy") Optional<NullPartitioning> nullPartitionPolicy, @JsonProperty(value="hash") Optional<Symbol> hash) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.root = Objects.requireNonNull(root, "root is null");
        this.symbols = Objects.requireNonNull(symbols, "symbols is null");
        this.outputLayout = Objects.requireNonNull(outputLayout, "outputLayout is null");
        this.distribution = Objects.requireNonNull(distribution, "distribution is null");
        this.partitionedSource = partitionedSource;
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null").map(ImmutableList::copyOf);
        this.nullPartitionPolicy = Objects.requireNonNull(nullPartitionPolicy, "nullPartitioningPolicy is null");
        this.hash = hash;
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(root.getOutputSymbols()).containsAll(outputLayout), (String)"Root node outputs (%s) don't include all fragment outputs (%s)", (Object[])new Object[]{root.getOutputSymbols(), outputLayout});
        this.types = (List)outputLayout.stream().map(symbols::get).collect(ImmutableCollectors.toImmutableList());
        this.partitionedSourceNode = PlanFragment.findSource(root, partitionedSource);
        ImmutableList.Builder remoteSourceNodes = ImmutableList.builder();
        PlanFragment.findRemoteSourceNodes(root, (ImmutableList.Builder<RemoteSourceNode>)remoteSourceNodes);
        this.remoteSourceNodes = remoteSourceNodes.build();
        this.outputPartitioning = Objects.requireNonNull(outputPartitioning, "outputPartitioning is null");
    }

    @JsonProperty
    public PlanFragmentId getId() {
        return this.id;
    }

    @JsonProperty
    public PlanNode getRoot() {
        return this.root;
    }

    @JsonProperty
    public Map<Symbol, Type> getSymbols() {
        return this.symbols;
    }

    @JsonProperty
    public List<Symbol> getOutputLayout() {
        return this.outputLayout;
    }

    @JsonProperty
    public PlanDistribution getDistribution() {
        return this.distribution;
    }

    @JsonProperty
    public PlanNodeId getPartitionedSource() {
        return this.partitionedSource;
    }

    @JsonProperty
    public OutputPartitioning getOutputPartitioning() {
        return this.outputPartitioning;
    }

    @JsonProperty
    public Optional<List<Symbol>> getPartitionBy() {
        return this.partitionBy;
    }

    public Optional<NullPartitioning> getNullPartitionPolicy() {
        return this.nullPartitionPolicy;
    }

    @JsonProperty
    public Optional<Symbol> getHash() {
        return this.hash;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public PlanNode getPartitionedSourceNode() {
        return this.partitionedSourceNode;
    }

    public boolean isLeaf() {
        return this.remoteSourceNodes.isEmpty();
    }

    public List<RemoteSourceNode> getRemoteSourceNodes() {
        return this.remoteSourceNodes;
    }

    private static PlanNode findSource(PlanNode node, PlanNodeId nodeId) {
        if (node.getId().equals(nodeId)) {
            return node;
        }
        return node.getSources().stream().map(source -> PlanFragment.findSource(source, nodeId)).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static void findRemoteSourceNodes(PlanNode node, ImmutableList.Builder<RemoteSourceNode> builder) {
        for (PlanNode source : node.getSources()) {
            PlanFragment.findRemoteSourceNodes(source, builder);
        }
        if (node instanceof RemoteSourceNode) {
            builder.add((Object)((RemoteSourceNode)node));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("distribution", (Object)this.distribution).add("partitionedSource", (Object)this.partitionedSource).add("outputPartitioning", (Object)this.outputPartitioning).add("hash", this.hash).toString();
    }

    public static enum NullPartitioning {
        HASH,
        REPLICATE;

    }

    public static enum OutputPartitioning {
        NONE,
        HASH,
        ROUND_ROBIN;

    }

    public static enum PlanDistribution {
        SINGLE,
        FIXED,
        SOURCE,
        COORDINATOR_ONLY;

    }
}

