/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.google.common.collect.ImmutableMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class InterpretedFilterFunction
implements FilterFunction {
    private final ExpressionInterpreter evaluator;

    public InterpretedFilterFunction(Expression predicate, Map<Symbol, Type> symbolTypes, Map<Symbol, Integer> symbolToInputMappings, Metadata metadata, SqlParser sqlParser, Session session) {
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new SymbolToInputRewriter(symbolToInputMappings), (Expression)predicate);
        ImmutableMap.Builder inputTypes = ImmutableMap.builder();
        for (Map.Entry<Symbol, Integer> entry : symbolToInputMappings.entrySet()) {
            inputTypes.put((Object)entry.getValue(), (Object)symbolTypes.get(entry.getKey()));
        }
        IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(session, metadata, sqlParser, (Map<Integer, Type>)inputTypes.build(), rewritten);
        this.evaluator = ExpressionInterpreter.expressionInterpreter(rewritten, metadata, session, expressionTypes);
    }

    @Override
    public boolean filter(int position, Block ... blocks) {
        return this.evaluator.evaluate(position, blocks) == Boolean.TRUE;
    }

    @Override
    public boolean filter(RecordCursor cursor) {
        return this.evaluator.evaluate(cursor) == Boolean.TRUE;
    }
}

