/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.ByteCodeExpressionVisitor;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class PageProcessorCompiler
implements BodyCompiler<PageProcessor> {
    private final Metadata metadata;

    public PageProcessorCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<RowExpression> projections) {
        ImmutableList.Builder projectionMethods = ImmutableList.builder();
        for (int i = 0; i < projections.size(); ++i) {
            projectionMethods.add((Object)this.generateProjectMethod(classDefinition, callSiteBinder, "project_" + i, projections.get(i)));
        }
        PageProcessorCompiler.generateProcessMethod(classDefinition, filter, projections, (List<MethodDefinition>)projectionMethods.build());
        this.generateFilterMethod(classDefinition, callSiteBinder, filter);
    }

    private static void generateProcessMethod(ClassDefinition classDefinition, RowExpression filter, List<RowExpression> projections, List<MethodDefinition> projectionMethods) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter page = Parameter.arg("page", Page.class);
        Parameter start = Parameter.arg("start", Integer.TYPE);
        Parameter end = Parameter.arg("end", Integer.TYPE);
        Parameter pageBuilder = Parameter.arg("pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "process", ParameterizedType.type(Integer.TYPE), session, page, start, end, pageBuilder);
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        List<Integer> allInputChannels = PageProcessorCompiler.getInputChannels(Iterables.concat(projections, (Iterable)ImmutableList.of((Object)filter)));
        ImmutableMap.Builder channelBlockBuilder = ImmutableMap.builder();
        for (int channel : allInputChannels) {
            Variable blockVariable = scope.declareVariable(Block.class, "block_" + channel);
            method.getBody().append(blockVariable.set(page.invoke("getBlock", Block.class, ByteCodeExpressions.constantInt(channel))));
            channelBlockBuilder.put((Object)channel, (Object)blockVariable);
        }
        ImmutableMap channelBlock = channelBlockBuilder.build();
        Map<RowExpression, List<Variable>> expressionInputBlocks = PageProcessorCompiler.getExpressionInputBlocks(projections, filter, (Map<Integer, Variable>)channelBlock);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
            Variable blockBuilder = scope.declareVariable(BlockBuilder.class, "blockBuilder_" + projectionIndex);
            method.getBody().append(blockBuilder.set(pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, ByteCodeExpressions.constantInt(projectionIndex))));
            builder.add((Object)blockBuilder);
        }
        ImmutableList blockBuilders = builder.build();
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        ByteCodeBlock project = new ByteCodeBlock().append(pageBuilder.invoke("declarePosition", Void.TYPE, new ByteCodeExpression[0]));
        for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
            RowExpression projection = projections.get(projectionIndex);
            project.append(PageProcessorCompiler.invokeProject(thisVariable, session, expressionInputBlocks.get(projection), position, (Variable)blockBuilders.get(projectionIndex), projectionMethods.get(projectionIndex)));
        }
        LabelNode done = new LabelNode("done");
        ForLoop loop = new ForLoop().initialize(position.set(start)).condition(ByteCodeExpressions.lessThan(position, end)).update(position.set(ByteCodeExpressions.add(position, ByteCodeExpressions.constantInt(1)))).body(new ByteCodeBlock().append(new IfStatement().condition(pageBuilder.invoke("isFull", Boolean.TYPE, new ByteCodeExpression[0])).ifTrue(JumpInstruction.jump(done))).append(new IfStatement().condition(PageProcessorCompiler.invokeFilter(thisVariable, session, expressionInputBlocks.get(filter), position)).ifTrue(project)));
        method.getBody().append(loop).visitLabel(done).append(position.ret());
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        List<Parameter> blocks = PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(filter));
        Parameter position = Parameter.arg("position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable<Parameter>)ImmutableList.builder().add((Object)session).addAll(blocks).add((Object)position).build());
        method.comment("Filter: %s", filter.toString());
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, PageProcessorCompiler.fieldReferenceCompiler(callSiteBinder, position, wasNullVariable), this.metadata.getFunctionRegistry());
        ByteCodeNode body = filter.accept(visitor, scope);
        LabelNode end = new LabelNode("end");
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).append(body).getVariable(wasNullVariable).ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
    }

    private MethodDefinition generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String methodName, RowExpression projection) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        List<Parameter> inputs = PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(projection));
        Parameter position = Parameter.arg("position", Integer.TYPE);
        Parameter output = Parameter.arg("output", BlockBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), methodName, ParameterizedType.type(Void.TYPE), (Iterable<Parameter>)ImmutableList.builder().add((Object)session).addAll(inputs).add((Object)position).add((Object)output).build());
        method.comment("Projection: %s", projection.toString());
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        ByteCodeBlock body = method.getBody().append(wasNullVariable.set(ByteCodeExpressions.constantFalse()));
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, PageProcessorCompiler.fieldReferenceCompiler(callSiteBinder, position, wasNullVariable), this.metadata.getFunctionRegistry());
        body.getVariable(output).comment("evaluate projection: " + projection.toString()).append(projection.accept(visitor, scope)).append(ByteCodeUtils.generateWrite(callSiteBinder, scope, wasNullVariable, projection.getType())).ret();
        return method;
    }

    private static List<Integer> getInputChannels(Iterable<RowExpression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (RowExpression expression : Expressions.subExpressions(expressions)) {
            if (!(expression instanceof InputReferenceExpression)) continue;
            channels.add(((InputReferenceExpression)expression).getField());
        }
        return ImmutableList.copyOf(channels);
    }

    private static List<Integer> getInputChannels(RowExpression expression) {
        return PageProcessorCompiler.getInputChannels((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    private static List<Parameter> toBlockParameters(List<Integer> inputChannels) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int channel : inputChannels) {
            parameters.add((Object)Parameter.arg("block_" + channel, Block.class));
        }
        return parameters.build();
    }

    private static RowExpressionVisitor<Scope, ByteCodeNode> fieldReferenceCompiler(final CallSiteBinder callSiteBinder, final Variable positionVariable, final Variable wasNullVariable) {
        return new RowExpressionVisitor<Scope, ByteCodeNode>(){

            @Override
            public ByteCodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                int field = node.getField();
                Type type = node.getType();
                Variable block = scope.getVariable("block_" + field);
                Class<Object> javaType = type.getJavaType();
                if (!javaType.isPrimitive() && javaType != Slice.class) {
                    javaType = Object.class;
                }
                IfStatement ifStatement = new IfStatement();
                ifStatement.condition().setDescription(String.format("block_%d.get%s()", field, type)).append(block).getVariable(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, Integer.TYPE);
                ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(javaType);
                String methodName = "get" + Primitives.wrap(javaType).getSimpleName();
                ifStatement.ifFalse().append(ByteCodeUtils.loadConstant(callSiteBinder.bind(type, Type.class))).append(block).getVariable(positionVariable).invokeInterface(Type.class, methodName, javaType, Block.class, Integer.TYPE);
                return ifStatement;
            }

            @Override
            public ByteCodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public ByteCodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }

    private static Map<RowExpression, List<Variable>> getExpressionInputBlocks(List<RowExpression> projections, RowExpression filter, Map<Integer, Variable> channelBlock) {
        HashMap<RowExpression, List<Variable>> inputBlocksBuilder = new HashMap<RowExpression, List<Variable>>();
        for (RowExpression projection : projections) {
            List inputBlocks = PageProcessorCompiler.getInputChannels(projection).stream().map(channelBlock::get).collect(Collectors.toList());
            List existingVariables = (List)inputBlocksBuilder.get(projection);
            Preconditions.checkState((existingVariables == null || existingVariables.equals(inputBlocks) ? 1 : 0) != 0, (Object)"malformed RowExpression");
            inputBlocksBuilder.put(projection, inputBlocks);
        }
        List filterBlocks = PageProcessorCompiler.getInputChannels(filter).stream().map(channelBlock::get).collect(Collectors.toList());
        inputBlocksBuilder.put(filter, filterBlocks);
        return inputBlocksBuilder;
    }

    private static ByteCodeExpression invokeFilter(ByteCodeExpression objRef, ByteCodeExpression session, List<? extends ByteCodeExpression> blockVariables, ByteCodeExpression position) {
        ImmutableList params = ImmutableList.builder().add((Object)session).addAll(blockVariables).add((Object)position).build();
        return objRef.invoke("filter", Boolean.TYPE, (Iterable<? extends ByteCodeExpression>)params);
    }

    private static ByteCodeNode invokeProject(Variable objRef, Variable session, List<Variable> blockVariables, ByteCodeExpression position, Variable blockBuilder, MethodDefinition projectionMethod) {
        ImmutableList params = ImmutableList.builder().add((Object)session).addAll(blockVariables).add((Object)position).add((Object)blockBuilder).build();
        return new ByteCodeBlock().append(objRef.invoke(projectionMethod, (Iterable<? extends ByteCodeExpression>)params));
    }
}

