/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupJoinOperator;
import com.facebook.presto.operator.LookupJoinOperatorFactory;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.IsolatedClass;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class JoinProbeCompiler {
    private final LoadingCache<JoinOperatorCacheKey, HashJoinOperatorFactoryFactory> joinProbeFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<JoinOperatorCacheKey, HashJoinOperatorFactoryFactory>(){

        public HashJoinOperatorFactoryFactory load(JoinOperatorCacheKey key) throws Exception {
            return JoinProbeCompiler.this.internalCompileJoinOperatorFactory(key.getTypes(), key.getProbeChannels(), key.getProbeHashChannel());
        }
    });

    public OperatorFactory compileJoinOperatorFactory(int operatorId, LookupSourceSupplier lookupSourceSupplier, List<? extends Type> probeTypes, List<Integer> probeJoinChannel, Optional<Integer> probeHashChannel, LookupJoinOperators.JoinType joinType) {
        try {
            HashJoinOperatorFactoryFactory operatorFactoryFactory = (HashJoinOperatorFactoryFactory)this.joinProbeFactories.get((Object)new JoinOperatorCacheKey(probeTypes, probeJoinChannel, probeHashChannel, joinType));
            return operatorFactoryFactory.createHashJoinOperatorFactory(operatorId, lookupSourceSupplier, probeTypes, probeJoinChannel, joinType);
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public HashJoinOperatorFactoryFactory internalCompileJoinOperatorFactory(List<Type> types, List<Integer> probeJoinChannel, Optional<Integer> probeHashChannel) {
        JoinProbeFactory joinProbeFactory;
        Class<? extends JoinProbe> joinProbeClass = this.compileJoinProbe(types, probeJoinChannel, probeHashChannel);
        ClassDefinition classDefinition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("JoinProbeFactory"), ParameterizedType.type(Object.class), ParameterizedType.type(JoinProbeFactory.class));
        classDefinition.declareDefaultConstructor(Access.a(Access.PUBLIC));
        Parameter lookupSource = Parameter.arg("lookupSource", LookupSource.class);
        Parameter page = Parameter.arg("page", Page.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "createJoinProbe", ParameterizedType.type(JoinProbe.class), lookupSource, page);
        method.getBody().newObject(joinProbeClass).dup().append(lookupSource).append(page).invokeConstructor(joinProbeClass, LookupSource.class, Page.class).retObject();
        DynamicClassLoader classLoader = new DynamicClassLoader(joinProbeClass.getClassLoader());
        Class<JoinProbeFactory> joinProbeFactoryClass = CompilerUtils.defineClass(classDefinition, JoinProbeFactory.class, classLoader);
        try {
            joinProbeFactory = joinProbeFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Class<LookupJoinOperatorFactory> operatorFactoryClass = IsolatedClass.isolateClass(classLoader, OperatorFactory.class, LookupJoinOperatorFactory.class, LookupJoinOperator.class);
        return new HashJoinOperatorFactoryFactory(joinProbeFactory, operatorFactoryClass);
    }

    @VisibleForTesting
    public JoinProbeFactory internalCompileJoinProbe(List<Type> types, List<Integer> probeChannels, Optional<Integer> probeHashChannel) {
        return new ReflectionJoinProbeFactory(this.compileJoinProbe(types, probeChannels, probeHashChannel));
    }

    private Class<? extends JoinProbe> compileJoinProbe(List<Type> types, List<Integer> probeChannels, Optional<Integer> probeHashChannel) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("JoinProbe"), ParameterizedType.type(Object.class), ParameterizedType.type(JoinProbe.class));
        FieldDefinition lookupSourceField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "lookupSource", LookupSource.class);
        FieldDefinition positionCountField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "positionCount", Integer.TYPE);
        ArrayList<FieldDefinition> blockFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < types.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "block_" + i, Block.class);
            blockFields.add(channelField);
        }
        ArrayList<FieldDefinition> probeBlockFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < probeChannels.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "probeBlock_" + i, Block.class);
            probeBlockFields.add(channelField);
        }
        FieldDefinition probeBlocksArrayField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "probeBlocks", Block[].class);
        FieldDefinition probePageField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "probePage", Page.class);
        FieldDefinition positionField = classDefinition.declareField(Access.a(Access.PRIVATE), "position", Integer.TYPE);
        FieldDefinition probeHashBlockField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "probeHashBlock", Block.class);
        this.generateConstructor(classDefinition, probeChannels, probeHashChannel, lookupSourceField, blockFields, probeBlockFields, probeBlocksArrayField, probePageField, probeHashBlockField, positionField, positionCountField);
        this.generateGetChannelCountMethod(classDefinition, blockFields.size());
        this.generateAppendToMethod(classDefinition, callSiteBinder, types, blockFields, positionField);
        this.generateAdvanceNextPosition(classDefinition, positionField, positionCountField);
        this.generateGetCurrentJoinPosition(classDefinition, callSiteBinder, lookupSourceField, probePageField, probeHashChannel, probeHashBlockField, positionField);
        this.generateCurrentRowContainsNull(classDefinition, probeBlockFields, positionField);
        return CompilerUtils.defineClass(classDefinition, JoinProbe.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private void generateConstructor(ClassDefinition classDefinition, List<Integer> probeChannels, Optional<Integer> probeHashChannel, FieldDefinition lookupSourceField, List<FieldDefinition> blockFields, List<FieldDefinition> probeChannelFields, FieldDefinition probeBlocksArrayField, FieldDefinition probePageField, FieldDefinition probeHashBlockField, FieldDefinition positionField, FieldDefinition positionCountField) {
        int index;
        Parameter lookupSource = Parameter.arg("lookupSource", LookupSource.class);
        Parameter page = Parameter.arg("page", Page.class);
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a(Access.PUBLIC), lookupSource, page);
        Variable thisVariable = constructorDefinition.getThis();
        ByteCodeBlock constructor = constructorDefinition.getBody().comment("super();").append(thisVariable).invokeConstructor(Object.class, new Class[0]);
        constructor.comment("this.lookupSource = lookupSource;").append(thisVariable.setField(lookupSourceField, (ByteCodeExpression)lookupSource));
        constructor.comment("this.positionCount = page.getPositionCount();").append(thisVariable.setField(positionCountField, page.invoke("getPositionCount", Integer.TYPE, new ByteCodeExpression[0])));
        constructor.comment("Set block fields");
        for (index = 0; index < blockFields.size(); ++index) {
            constructor.append(thisVariable.setField(blockFields.get(index), page.invoke("getBlock", Block.class, ByteCodeExpressions.constantInt(index))));
        }
        constructor.comment("Set probe channel fields");
        for (index = 0; index < probeChannelFields.size(); ++index) {
            constructor.append(thisVariable.setField(probeChannelFields.get(index), thisVariable.getField(blockFields.get(probeChannels.get(index)))));
        }
        constructor.comment("this.probeBlocks = new Block[<probeChannelCount>];");
        constructor.append(thisVariable).push(probeChannelFields.size()).newArray(Block.class).putField(probeBlocksArrayField);
        for (index = 0; index < probeChannelFields.size(); ++index) {
            constructor.append(thisVariable).getField(probeBlocksArrayField).push(index).append(thisVariable).getField(probeChannelFields.get(index)).putObjectArrayElement();
        }
        constructor.comment("this.probePage = new Page(probeBlocks)").append(thisVariable.setField(probePageField, ByteCodeExpressions.newInstance(Page.class, thisVariable.getField(probeBlocksArrayField))));
        if (probeHashChannel.isPresent()) {
            Integer index2 = probeHashChannel.get();
            constructor.comment("this.probeHashBlock = blocks[hashChannel.get()]").append(thisVariable.setField(probeHashBlockField, thisVariable.getField(blockFields.get(index2))));
        }
        constructor.comment("this.position = -1;").append(thisVariable.setField(positionField, ByteCodeExpressions.constantInt(-1)));
        constructor.ret();
    }

    private void generateGetChannelCountMethod(ClassDefinition classDefinition, int channelCount) {
        classDefinition.declareMethod(Access.a(Access.PUBLIC), "getChannelCount", ParameterizedType.type(Integer.TYPE), new Parameter[0]).getBody().push(channelCount).retInt();
    }

    private void generateAppendToMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<FieldDefinition> blockFields, FieldDefinition positionField) {
        Parameter pageBuilder = Parameter.arg("pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "appendTo", ParameterizedType.type(Void.TYPE), pageBuilder);
        Variable thisVariable = method.getThis();
        for (int index = 0; index < blockFields.size(); ++index) {
            Type type = types.get(index);
            method.getBody().comment("%s.appendTo(block_%s, position, pageBuilder.getBlockBuilder(%s));", type.getClass(), index, index).append(SqlTypeByteCodeExpression.constantType(callSiteBinder, type).invoke("appendTo", Void.TYPE, thisVariable.getField(blockFields.get(index)), thisVariable.getField(positionField), pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, ByteCodeExpressions.constantInt(index))));
        }
        method.getBody().ret();
    }

    private void generateAdvanceNextPosition(ClassDefinition classDefinition, FieldDefinition positionField, FieldDefinition positionCountField) {
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "advanceNextPosition", ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        Variable thisVariable = method.getThis();
        method.getBody().comment("this.position = this.position + 1;").append(thisVariable).append(thisVariable).getField(positionField).push(1).intAdd().putField(positionField);
        LabelNode lessThan = new LabelNode("lessThan");
        LabelNode end = new LabelNode("end");
        method.getBody().comment("return position < positionCount;").append(thisVariable).getField(positionField).append(thisVariable).getField(positionCountField).append(JumpInstruction.jumpIfIntLessThan(lessThan)).push(false).gotoLabel(end).visitLabel(lessThan).push(true).visitLabel(end).retBoolean();
    }

    private void generateGetCurrentJoinPosition(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, FieldDefinition lookupSourceField, FieldDefinition probePageField, Optional<Integer> probeHashChannel, FieldDefinition probeHashBlockField, FieldDefinition positionField) {
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "getCurrentJoinPosition", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        Variable thisVariable = method.getThis();
        ByteCodeBlock body = method.getBody().append(new IfStatement().condition(thisVariable.invoke("currentRowContainsNull", Boolean.TYPE, new ByteCodeExpression[0])).ifTrue(ByteCodeExpressions.constantLong(-1L).ret()));
        ByteCodeExpression position = thisVariable.getField(positionField);
        ByteCodeExpression page = thisVariable.getField(probePageField);
        ByteCodeExpression probeHashBlock = thisVariable.getField(probeHashBlockField);
        if (probeHashChannel.isPresent()) {
            body.append(thisVariable.getField(lookupSourceField).invoke("getJoinPosition", Long.TYPE, position, page, SqlTypeByteCodeExpression.constantType(callSiteBinder, (Type)BigintType.BIGINT).invoke("getLong", Long.TYPE, probeHashBlock, position).cast(Integer.TYPE))).retLong();
        } else {
            body.append(thisVariable.getField(lookupSourceField).invoke("getJoinPosition", Long.TYPE, position, page)).retLong();
        }
    }

    private void generateCurrentRowContainsNull(ClassDefinition classDefinition, List<FieldDefinition> probeBlockFields, FieldDefinition positionField) {
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PRIVATE), "currentRowContainsNull", ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        Variable thisVariable = method.getThis();
        for (FieldDefinition probeBlockField : probeBlockFields) {
            LabelNode checkNextField = new LabelNode("checkNextField");
            method.getBody().append(thisVariable.getField(probeBlockField).invoke("isNull", Boolean.TYPE, thisVariable.getField(positionField))).ifFalseGoto(checkNextField).push(true).retBoolean().visitLabel(checkNextField);
        }
        method.getBody().push(false).retInt();
    }

    public static void checkState(boolean left, boolean right) {
        if (left != right) {
            throw new IllegalStateException();
        }
    }

    private static class HashJoinOperatorFactoryFactory {
        private final JoinProbeFactory joinProbeFactory;
        private final Constructor<? extends OperatorFactory> constructor;

        private HashJoinOperatorFactoryFactory(JoinProbeFactory joinProbeFactory, Class<? extends OperatorFactory> operatorFactoryClass) {
            this.joinProbeFactory = joinProbeFactory;
            try {
                this.constructor = operatorFactoryClass.getConstructor(Integer.TYPE, LookupSourceSupplier.class, List.class, LookupJoinOperators.JoinType.class, JoinProbeFactory.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public OperatorFactory createHashJoinOperatorFactory(int operatorId, LookupSourceSupplier lookupSourceSupplier, List<? extends Type> probeTypes, List<Integer> probeJoinChannel, LookupJoinOperators.JoinType joinType) {
            try {
                return this.constructor.newInstance(new Object[]{operatorId, lookupSourceSupplier, probeTypes, joinType, this.joinProbeFactory});
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class JoinOperatorCacheKey {
        private final List<Type> types;
        private final List<Integer> probeChannels;
        private final LookupJoinOperators.JoinType joinType;
        private final Optional<Integer> probeHashChannel;

        private JoinOperatorCacheKey(List<? extends Type> types, List<Integer> probeChannels, Optional<Integer> probeHashChannel, LookupJoinOperators.JoinType joinType) {
            this.probeHashChannel = probeHashChannel;
            this.types = ImmutableList.copyOf(types);
            this.probeChannels = ImmutableList.copyOf(probeChannels);
            this.joinType = joinType;
        }

        private List<Type> getTypes() {
            return this.types;
        }

        private List<Integer> getProbeChannels() {
            return this.probeChannels;
        }

        private Optional<Integer> getProbeHashChannel() {
            return this.probeHashChannel;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.types, this.probeChannels, this.joinType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JoinOperatorCacheKey)) {
                return false;
            }
            JoinOperatorCacheKey other = (JoinOperatorCacheKey)obj;
            return Objects.equals(this.types, other.types) && Objects.equals(this.probeChannels, other.probeChannels) && Objects.equals(this.probeHashChannel, other.probeHashChannel) && Objects.equals((Object)this.joinType, (Object)other.joinType);
        }
    }

    public static class ReflectionJoinProbeFactory
    implements JoinProbeFactory {
        private final Constructor<? extends JoinProbe> constructor;

        public ReflectionJoinProbeFactory(Class<? extends JoinProbe> joinProbeClass) {
            try {
                this.constructor = joinProbeClass.getConstructor(LookupSource.class, Page.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public JoinProbe createJoinProbe(LookupSource lookupSource, Page page) {
            try {
                return this.constructor.newInstance(lookupSource, page);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

