/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import java.util.List;

public class IsNullCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0);
        RowExpression argument = arguments.get(0);
        if (argument.getType().equals((Object)UnknownType.UNKNOWN)) {
            return Constant.loadBoolean(true);
        }
        ByteCodeNode value = generatorContext.generate(argument);
        Variable wasNull = generatorContext.wasNull();
        ByteCodeBlock block = new ByteCodeBlock().comment("is null").append(value).pop(argument.getType().getJavaType()).append(wasNull);
        block.append(wasNull.set(ByteCodeExpressions.constantFalse()));
        return block;
    }
}

