/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.TaskSource;
import com.facebook.presto.sql.planner.PlanFragment;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class TaskUpdateRequest {
    private final SessionRepresentation session;
    private final PlanFragment fragment;
    private final List<TaskSource> sources;
    private final OutputBuffers outputIds;

    @JsonCreator
    public TaskUpdateRequest(@JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="fragment") PlanFragment fragment, @JsonProperty(value="sources") List<TaskSource> sources, @JsonProperty(value="outputIds") OutputBuffers outputIds) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(fragment, "fragment is null");
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(outputIds, "outputIds is null");
        this.session = session;
        this.fragment = fragment;
        this.sources = ImmutableList.copyOf(sources);
        this.outputIds = outputIds;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public PlanFragment getFragment() {
        return this.fragment;
    }

    @JsonProperty
    public List<TaskSource> getSources() {
        return this.sources;
    }

    @JsonProperty
    public OutputBuffers getOutputIds() {
        return this.outputIds;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", (Object)this.session).add("fragment", (Object)this.fragment).add("sources", this.sources).add("outputIds", (Object)this.outputIds).toString();
    }
}

