/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class FrameInfo {
    private final WindowFrame.Type type;
    private final FrameBound.Type startType;
    private final int startChannel;
    private final FrameBound.Type endType;
    private final int endChannel;

    public FrameInfo(WindowFrame.Type type, FrameBound.Type startType, Optional<Integer> startChannel, FrameBound.Type endType, Optional<Integer> endChannel) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.startType = Objects.requireNonNull(startType, "startType is null");
        this.startChannel = Objects.requireNonNull(startChannel, "startChannel is null").orElse(-1);
        this.endType = Objects.requireNonNull(endType, "endType is null");
        this.endChannel = Objects.requireNonNull(endChannel, "endChannel is null").orElse(-1);
    }

    public WindowFrame.Type getType() {
        return this.type;
    }

    public FrameBound.Type getStartType() {
        return this.startType;
    }

    public int getStartChannel() {
        return this.startChannel;
    }

    public FrameBound.Type getEndType() {
        return this.endType;
    }

    public int getEndChannel() {
        return this.endChannel;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("startType", (Object)this.startType).add("startChannel", this.startChannel).add("endType", (Object)this.endType).add("endChannel", this.endChannel).toString();
    }
}

