/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class TupleFilterProcessor
implements PageProcessor {
    private final Page tuplePage;
    private final List<Type> outputTypes;
    private final int[] outputTupleChannels;

    public TupleFilterProcessor(Page tuplePage, List<Type> outputTypes, int[] outputTupleChannels) {
        Objects.requireNonNull(tuplePage, "tuplePage is null");
        Preconditions.checkArgument((tuplePage.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"tuplePage should only have one position");
        Preconditions.checkArgument((tuplePage.getChannelCount() > 0 ? 1 : 0) != 0, (Object)"tuplePage must have at least one channel");
        Objects.requireNonNull(outputTypes, "outputTypes is null");
        Objects.requireNonNull(outputTupleChannels, "outputTupleChannels is null");
        Preconditions.checkArgument((tuplePage.getChannelCount() == outputTupleChannels.length ? 1 : 0) != 0, (Object)"tuplePage and outputTupleChannels have different number of channels");
        Preconditions.checkArgument((outputTypes.size() >= outputTupleChannels.length ? 1 : 0) != 0, (Object)"Must have at least as many output channels as those used for filtering");
        this.tuplePage = tuplePage;
        this.outputTypes = ImmutableList.copyOf(outputTypes);
        this.outputTupleChannels = outputTupleChannels;
    }

    @Override
    public int process(ConnectorSession session, Page page, int start, int end, PageBuilder pageBuilder) {
        for (int position = start; position < end; ++position) {
            if (!this.matches(position, page)) continue;
            pageBuilder.declarePosition();
            for (int i = 0; i < this.outputTypes.size(); ++i) {
                Type type = this.outputTypes.get(i);
                Block block = page.getBlock(i);
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                type.appendTo(block, position, blockBuilder);
            }
        }
        return end;
    }

    private boolean matches(int position, Page page) {
        for (int i = 0; i < this.outputTupleChannels.length; ++i) {
            Type type = this.outputTypes.get(this.outputTupleChannels[i]);
            Block outputBlock = page.getBlock(this.outputTupleChannels[i]);
            Block singleTupleBlock = this.tuplePage.getBlock(i);
            if (type.equalTo(singleTupleBlock, 0, outputBlock, position)) continue;
            return false;
        }
        return true;
    }
}

