/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.index.TupleFilterProcessor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class DynamicTupleFilterFactory {
    private final int filterOperatorId;
    private final int[] tupleFilterChannels;
    private final int[] outputFilterChannels;
    private final List<Type> outputTypes;

    public DynamicTupleFilterFactory(int filterOperatorId, int[] tupleFilterChannels, int[] outputFilterChannels, List<Type> outputTypes) {
        Objects.requireNonNull(tupleFilterChannels, "tupleFilterChannels is null");
        Preconditions.checkArgument((tupleFilterChannels.length > 0 ? 1 : 0) != 0, (Object)"Must have at least one tupleFilterChannel");
        Objects.requireNonNull(outputFilterChannels, "outputFilterChannels is null");
        Preconditions.checkArgument((outputFilterChannels.length == tupleFilterChannels.length ? 1 : 0) != 0, (Object)"outputFilterChannels must have same length as tupleFilterChannels");
        Objects.requireNonNull(outputTypes, "outputTypes is null");
        Preconditions.checkArgument((outputTypes.size() >= outputFilterChannels.length ? 1 : 0) != 0, (Object)"Must have at least as many output channels as those used for filtering");
        this.filterOperatorId = filterOperatorId;
        this.tupleFilterChannels = (int[])tupleFilterChannels.clone();
        this.outputFilterChannels = (int[])outputFilterChannels.clone();
        this.outputTypes = ImmutableList.copyOf(outputTypes);
    }

    public OperatorFactory filterWithTuple(Page tuplePage) {
        Page normalizedTuplePage = this.normalizeTuplePage(tuplePage);
        TupleFilterProcessor processor = new TupleFilterProcessor(normalizedTuplePage, this.outputTypes, this.outputFilterChannels);
        return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(this.filterOperatorId, processor, this.outputTypes);
    }

    private Page normalizeTuplePage(Page tuplePage) {
        Block[] normalizedBlocks = new Block[this.tupleFilterChannels.length];
        for (int i = 0; i < this.tupleFilterChannels.length; ++i) {
            normalizedBlocks[i] = tuplePage.getBlock(this.tupleFilterChannels[i]);
        }
        return new Page(normalizedBlocks);
    }
}

