/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.TypedHistogram;
import com.facebook.presto.operator.aggregation.state.HistogramState;
import com.facebook.presto.operator.aggregation.state.HistogramStateFactory;
import com.facebook.presto.operator.aggregation.state.HistogramStateSerializer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.MapType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class Histogram
extends SqlAggregationFunction {
    public static final Histogram HISTOGRAM = new Histogram();
    public static final String NAME = "histogram";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(Histogram.class, "output", Type.class, HistogramState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(Histogram.class, "input", Type.class, HistogramState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(Histogram.class, "combine", HistogramState.class, HistogramState.class);
    public static final int EXPECTED_SIZE_FOR_HASHING = 10;

    public Histogram() {
        super(NAME, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("K")), "map<K,bigint>", (List<String>)ImmutableList.of((Object)"K"));
    }

    @Override
    public String getDescription() {
        return "Count the number of times each value occurs";
    }

    @Override
    public InternalAggregationFunction specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = types.get("K");
        BigintType valueType = BigintType.BIGINT;
        return Histogram.generateAggregation(keyType, (Type)valueType);
    }

    private static InternalAggregationFunction generateAggregation(Type keyType, Type valueType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(Histogram.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)keyType);
        MapType outputType = new MapType(keyType, valueType);
        HistogramStateSerializer stateSerializer = new HistogramStateSerializer(keyType);
        Type intermediateType = stateSerializer.getSerializedType();
        MethodHandle inputFunction = INPUT_FUNCTION.bindTo(keyType);
        MethodHandle outputFunction = OUTPUT_FUNCTION.bindTo((Object)outputType);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, (Type)outputType, (List<Type>)inputTypes), Histogram.createInputParameterMetadata(keyType), inputFunction, null, null, COMBINE_FUNCTION, outputFunction, HistogramState.class, stateSerializer, new HistogramStateFactory(), (Type)outputType, false);
        GenericAccumulatorFactoryBinder factory = new AccumulatorCompiler().generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, intermediateType, (Type)outputType, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type keyType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, keyType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(Type type, HistogramState state, Block key, int position) {
        TypedHistogram typedHistogram = state.get();
        if (typedHistogram == null) {
            typedHistogram = new TypedHistogram(type, 10);
            state.set(typedHistogram);
        }
        long startSize = typedHistogram.getEstimatedSize();
        try {
            typedHistogram.add(position, key, 1L);
        }
        catch (ExceededMemoryLimitException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("The result of histogram may not exceed %s", e.getMaxMemory()));
        }
        state.addMemoryUsage(typedHistogram.getEstimatedSize() - startSize);
    }

    public static void combine(HistogramState state, HistogramState otherState) {
        if (state.get() != null && otherState.get() != null) {
            TypedHistogram typedHistogram = state.get();
            long startSize = typedHistogram.getEstimatedSize();
            try {
                typedHistogram.addAll(otherState.get());
            }
            catch (ExceededMemoryLimitException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("The result of histogram may not exceed %s", e.getMaxMemory()));
            }
            state.addMemoryUsage(typedHistogram.getEstimatedSize() - startSize);
        } else if (state.get() == null) {
            state.set(otherState.get());
        }
    }

    public static void output(Type type, HistogramState state, BlockBuilder out) {
        TypedHistogram typedHistogram = state.get();
        if (typedHistogram == null) {
            out.appendNull();
        } else {
            Block block = typedHistogram.serialize();
            type.writeObject(out, (Object)block);
        }
    }
}

