/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.metadata.FunctionFactory;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class GenericAggregationFunctionFactory
implements FunctionFactory {
    private final List<SqlFunction> aggregations;

    public static GenericAggregationFunctionFactory fromAggregationDefinition(Class<?> clazz, TypeManager typeManager) {
        FunctionListBuilder builder = new FunctionListBuilder(typeManager);
        for (InternalAggregationFunction aggregation : new AggregationCompiler(typeManager).generateAggregationFunctions(clazz)) {
            builder.aggregate(aggregation);
        }
        return new GenericAggregationFunctionFactory(builder.getFunctions());
    }

    private GenericAggregationFunctionFactory(List<SqlFunction> aggregations) {
        this.aggregations = ImmutableList.copyOf((Collection)Objects.requireNonNull(aggregations, "aggregations is null"));
    }

    @Override
    public List<SqlFunction> listFunctions() {
        return this.aggregations;
    }
}

