/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileArrayAggregations;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.LongDoubleConverterUtil;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileArrayState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.SqlType;
import com.google.common.collect.ImmutableList;
import io.airlift.stats.QuantileDigest;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateDoublePercentileArrayAggregations {
    public static final InternalAggregationFunction DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateDoublePercentileArrayAggregations.class, (Type)new ArrayType((Type)DoubleType.DOUBLE), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)((Object)new ArrayType((Type)DoubleType.DOUBLE))));
    public static final InternalAggregationFunction DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateDoublePercentileArrayAggregations.class, (Type)new ArrayType((Type)DoubleType.DOUBLE), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT, (Object)((Object)new ArrayType((Type)DoubleType.DOUBLE))));

    private ApproximateDoublePercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(DigestAndPercentileArrayState state, @SqlType(value="double") double value, @SqlType(value="array<double>") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.input(state, LongDoubleConverterUtil.doubleToSortableLong(value), percentilesArrayBlock);
    }

    @InputFunction
    public static void weightedInput(DigestAndPercentileArrayState state, @SqlType(value="double") double value, @SqlType(value="bigint") long weight, @SqlType(value="array<double>") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.weightedInput(state, LongDoubleConverterUtil.doubleToSortableLong(value), weight, percentilesArrayBlock);
    }

    @CombineFunction
    public static void combine(DigestAndPercentileArrayState state, DigestAndPercentileArrayState otherState) {
        ApproximateLongPercentileArrayAggregations.combine(state, otherState);
    }

    @OutputFunction(value="array<double>")
    public static void output(DigestAndPercentileArrayState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        for (int i = 0; i < percentiles.size(); ++i) {
            Double percentile = percentiles.get(i);
            DoubleType.DOUBLE.writeDouble(blockBuilder, LongDoubleConverterUtil.sortableLongToDouble(digest.getQuantile(percentile.doubleValue())));
        }
        out.closeEntry();
    }
}

