/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.RowComparator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TopNRowNumberOperator
implements Operator {
    private static final DataSize OVERHEAD_PER_VALUE = new DataSize(100.0, DataSize.Unit.BYTE);
    private final OperatorContext operatorContext;
    private boolean finishing;
    private final List<Type> types;
    private final int[] outputChannels;
    private final List<Integer> sortChannels;
    private final List<SortOrder> sortOrders;
    private final List<Type> sortTypes;
    private final boolean generateRowNumber;
    private final int maxRowCountPerPartition;
    private final Map<Long, PartitionBuilder> partitionRows;
    private Optional<FlushingPartition> flushingPartition;
    private final PageBuilder pageBuilder;
    private final Optional<GroupByHash> groupByHash;

    public TopNRowNumberOperator(OperatorContext operatorContext, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<Type> partitionTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, List<Type> sortTypes, int maxRowCountPerPartition, boolean generateRowNumber, Optional<Integer> hashChannel, int expectedPositions) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.outputChannels = Ints.toArray((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
        this.sortChannels = Objects.requireNonNull(sortChannels, "sortChannels is null");
        this.sortOrders = Objects.requireNonNull(sortOrders, "sortOrders is null");
        this.sortTypes = Objects.requireNonNull(sortTypes, "sortTypes is null");
        Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
        this.maxRowCountPerPartition = maxRowCountPerPartition;
        this.generateRowNumber = generateRowNumber;
        Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions must be > 0");
        this.types = TopNRowNumberOperator.toTypes(sourceTypes, outputChannels, generateRowNumber);
        this.partitionRows = new HashMap<Long, PartitionBuilder>();
        this.groupByHash = partitionChannels.isEmpty() ? Optional.empty() : Optional.of(GroupByHash.createGroupByHash(partitionTypes, Ints.toArray(partitionChannels), Optional.empty(), hashChannel, expectedPositions));
        this.flushingPartition = Optional.empty();
        this.pageBuilder = new PageBuilder(this.types);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.isEmpty() && !this.isFlushing();
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && !this.isFlushing();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFlushing() ? 1 : 0) != 0, (Object)"Cannot add input with the operator is flushing data");
        this.processPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.finishing && !this.isFinished()) {
            return this.getPage();
        }
        return null;
    }

    private void processPage(Page page) {
        Optional<Object> partitionIds = Optional.empty();
        if (this.groupByHash.isPresent()) {
            GroupByHash hash = this.groupByHash.get();
            long groupByHashSize = hash.getEstimatedSize();
            partitionIds = Optional.of(hash.getGroupIds(page));
            this.operatorContext.reserveMemory(hash.getEstimatedSize() - groupByHashSize);
        }
        long sizeDelta = 0L;
        Block[] blocks = page.getBlocks();
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Block[] row;
            PartitionBuilder partitionBuilder;
            long partitionId;
            long l = partitionId = this.groupByHash.isPresent() ? ((GroupByIdBlock)partitionIds.get()).getGroupId(position) : 0L;
            if (!this.partitionRows.containsKey(partitionId)) {
                this.partitionRows.put(partitionId, new PartitionBuilder(this.sortTypes, this.sortChannels, this.sortOrders, this.maxRowCountPerPartition));
            }
            if ((partitionBuilder = this.partitionRows.get(partitionId)).getRowCount() < this.maxRowCountPerPartition) {
                row = TopNRowNumberOperator.getSingleValueBlocks(page, position);
                sizeDelta += partitionBuilder.addRow(row);
                continue;
            }
            if (this.compare(position, blocks, partitionBuilder.peekLastRow()) >= 0) continue;
            row = TopNRowNumberOperator.getSingleValueBlocks(page, position);
            sizeDelta += partitionBuilder.replaceRow(row);
        }
        if (sizeDelta > 0L) {
            this.operatorContext.reserveMemory(sizeDelta);
        } else {
            this.operatorContext.freeMemory(-sizeDelta);
        }
    }

    private int compare(int position, Block[] blocks, Block[] currentMax) {
        for (int i = 0; i < this.sortChannels.size(); ++i) {
            Block currentMaxValue;
            Block block;
            Type type = this.sortTypes.get(i);
            int sortChannel = this.sortChannels.get(i);
            SortOrder sortOrder = this.sortOrders.get(i);
            int compare = sortOrder.compareBlockValue(type, block = blocks[sortChannel], position, currentMaxValue = currentMax[sortChannel], 0);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private Page getPage() {
        if (!this.flushingPartition.isPresent()) {
            this.flushingPartition = this.getFlushingPartition();
        }
        this.pageBuilder.reset();
        long sizeDelta = 0L;
        while (!this.pageBuilder.isFull() && this.flushingPartition.isPresent()) {
            FlushingPartition currentFlushingPartition = this.flushingPartition.get();
            while (!this.pageBuilder.isFull() && currentFlushingPartition.hasNext()) {
                Block[] next = currentFlushingPartition.next();
                sizeDelta += TopNRowNumberOperator.sizeOfRow(next);
                this.pageBuilder.declarePosition();
                for (int i = 0; i < this.outputChannels.length; ++i) {
                    int channel = this.outputChannels[i];
                    Type type = this.types.get(channel);
                    type.appendTo(next[channel], 0, this.pageBuilder.getBlockBuilder(i));
                }
                if (!this.generateRowNumber) continue;
                BigintType.BIGINT.writeLong(this.pageBuilder.getBlockBuilder(this.outputChannels.length), (long)currentFlushingPartition.getRowNumber());
            }
            if (currentFlushingPartition.hasNext()) continue;
            this.flushingPartition = this.getFlushingPartition();
        }
        if (this.pageBuilder.isEmpty()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.operatorContext.freeMemory(sizeDelta);
        return page;
    }

    private Optional<FlushingPartition> getFlushingPartition() {
        int maxPartitionSize = 0;
        PartitionBuilder chosenPartitionBuilder = null;
        long chosenPartitionId = -1L;
        for (Map.Entry<Long, PartitionBuilder> entry : this.partitionRows.entrySet()) {
            if (entry.getValue().getRowCount() <= maxPartitionSize) continue;
            chosenPartitionBuilder = entry.getValue();
            maxPartitionSize = chosenPartitionBuilder.getRowCount();
            chosenPartitionId = entry.getKey();
            if (maxPartitionSize != this.maxRowCountPerPartition) continue;
            break;
        }
        if (chosenPartitionBuilder == null) {
            return Optional.empty();
        }
        FlushingPartition flushingPartition = new FlushingPartition(chosenPartitionBuilder.build());
        this.partitionRows.remove(chosenPartitionId);
        return Optional.of(flushingPartition);
    }

    public boolean isFlushing() {
        return this.flushingPartition.isPresent();
    }

    public boolean isEmpty() {
        return this.partitionRows.isEmpty();
    }

    private static Block[] getSingleValueBlocks(Page page, int position) {
        Block[] blocks = page.getBlocks();
        Block[] row = new Block[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            row[i] = blocks[i].getSingleValueBlock(position);
        }
        return row;
    }

    private static List<Type> toTypes(List<? extends Type> sourceTypes, List<Integer> outputChannels, boolean generateRowNumber) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (int channel : outputChannels) {
            types.add((Object)sourceTypes.get(channel));
        }
        if (generateRowNumber) {
            types.add((Object)BigintType.BIGINT);
        }
        return types.build();
    }

    private static long sizeOfRow(Block[] row) {
        long size = OVERHEAD_PER_VALUE.toBytes();
        for (Block value : row) {
            size += (long)value.getRetainedSizeInBytes();
        }
        return size;
    }

    private static class FlushingPartition
    implements Iterator<Block[]> {
        private final Iterator<Block[]> outputIterator;
        private int rowNumber;

        private FlushingPartition(Iterator<Block[]> outputIterator) {
            this.outputIterator = outputIterator;
        }

        @Override
        public boolean hasNext() {
            return this.outputIterator.hasNext();
        }

        @Override
        public Block[] next() {
            ++this.rowNumber;
            return this.outputIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int getRowNumber() {
            return this.rowNumber;
        }
    }

    private static class PartitionBuilder {
        private final MinMaxPriorityQueue<Block[]> candidateRows;
        private final int maxRowCountPerPartition;

        private PartitionBuilder(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, int maxRowCountPerPartition) {
            this.maxRowCountPerPartition = maxRowCountPerPartition;
            Ordering comparator = Ordering.from((Comparator)new RowComparator(sortTypes, sortChannels, sortOrders));
            this.candidateRows = MinMaxPriorityQueue.orderedBy((Comparator)comparator).maximumSize(maxRowCountPerPartition).create();
        }

        private long replaceRow(Block[] row) {
            Preconditions.checkState((this.candidateRows.size() == this.maxRowCountPerPartition ? 1 : 0) != 0);
            Block[] previousRow = (Block[])this.candidateRows.removeLast();
            long sizeDelta = this.addRow(row);
            return sizeDelta - TopNRowNumberOperator.sizeOfRow(previousRow);
        }

        private long addRow(Block[] row) {
            Preconditions.checkState((this.candidateRows.size() < this.maxRowCountPerPartition ? 1 : 0) != 0);
            long sizeDelta = TopNRowNumberOperator.sizeOfRow(row);
            this.candidateRows.add((Object)row);
            return sizeDelta;
        }

        private Iterator<Block[]> build() {
            ImmutableList.Builder sortedRows = ImmutableList.builder();
            while (!this.candidateRows.isEmpty()) {
                sortedRows.add(this.candidateRows.poll());
            }
            return sortedRows.build().iterator();
        }

        private int getRowCount() {
            return this.candidateRows.size();
        }

        private Block[] peekLastRow() {
            return (Block[])this.candidateRows.peekLast();
        }
    }

    public static class TopNRowNumberOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<Integer> partitionChannels;
        private final List<Type> partitionTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final int maxRowCountPerPartition;
        private final Optional<Integer> hashChannel;
        private final int expectedPositions;
        private final List<Type> types;
        private final List<Type> sortTypes;
        private final boolean generateRowNumber;
        private boolean closed;

        public TopNRowNumberOperatorFactory(int operatorId, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<? extends Type> partitionTypes, List<Integer> sortChannels, List<SortOrder> sortOrder, int maxRowCountPerPartition, boolean partial, Optional<Integer> hashChannel, int expectedPositions) {
            this.operatorId = operatorId;
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
            this.partitionTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionTypes, "partitionTypes is null"));
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels));
            this.sortOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrder));
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
            this.maxRowCountPerPartition = maxRowCountPerPartition;
            Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions must be > 0");
            this.generateRowNumber = !partial || !partitionChannels.isEmpty();
            this.expectedPositions = expectedPositions;
            this.types = TopNRowNumberOperator.toTypes(sourceTypes, outputChannels, this.generateRowNumber);
            ImmutableList.Builder sortTypes = ImmutableList.builder();
            for (int channel : sortChannels) {
                sortTypes.add((Object)this.types.get(channel));
            }
            this.sortTypes = sortTypes.build();
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TopNRowNumberOperator.class.getSimpleName());
            return new TopNRowNumberOperator(operatorContext, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.sortChannels, this.sortOrder, this.sortTypes, this.maxRowCountPerPartition, this.generateRowNumber, this.hashChannel, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

