/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

public final class SharedLookupSource
implements LookupSource {
    private final TaskContext taskContext;
    private final LookupSource lookupSource;
    @GuardedBy(value="this")
    private boolean freed;

    public SharedLookupSource(LookupSource lookupSource, OperatorContext operatorContext) {
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.lookupSource = Objects.requireNonNull(lookupSource, "lookupSource is null");
        this.taskContext = operatorContext.getDriverContext().getPipelineContext().getTaskContext();
        operatorContext.transferMemoryToTaskContext(lookupSource.getInMemorySizeInBytes());
    }

    @Override
    public int getChannelCount() {
        return this.lookupSource.getChannelCount();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.lookupSource.getInMemorySizeInBytes();
    }

    @Override
    public long getJoinPosition(int position, Page page, int rawHash) {
        return this.lookupSource.getJoinPosition(position, page, rawHash);
    }

    @Override
    public long getJoinPosition(int position, Page page) {
        return this.lookupSource.getJoinPosition(position, page);
    }

    @Override
    public long getNextJoinPosition(long currentPosition) {
        return this.lookupSource.getNextJoinPosition(currentPosition);
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.lookupSource.appendTo(position, pageBuilder, outputChannelOffset);
    }

    @Override
    public LongIterator getUnvisitedJoinPositions() {
        return this.lookupSource.getUnvisitedJoinPositions();
    }

    synchronized void freeMemory() {
        Preconditions.checkState((!this.freed ? 1 : 0) != 0, (Object)"Already freed");
        this.freed = true;
        this.taskContext.freeMemory(this.lookupSource.getInMemorySizeInBytes());
    }

    @Override
    public void close() {
        this.lookupSource.close();
    }
}

