/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class ScanFilterAndProjectOperator
implements SourceOperator,
Closeable {
    private static final int ROWS_PER_PAGE = 16384;
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final PageSourceProvider pageSourceProvider;
    private final List<Type> types;
    private final List<ColumnHandle> columns;
    private final PageBuilder pageBuilder;
    private final CursorProcessor cursorProcessor;
    private final PageProcessor pageProcessor;
    private final SettableFuture<?> blocked = SettableFuture.create();
    private RecordCursor cursor;
    private ConnectorPageSource pageSource;
    private Split split;
    private Page currentPage;
    private int currentPosition;
    private boolean finishing;
    private long completedBytes;
    private long readTimeNanos;

    protected ScanFilterAndProjectOperator(OperatorContext operatorContext, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, Iterable<ColumnHandle> columns, Iterable<Type> types) {
        this.cursorProcessor = Objects.requireNonNull(cursorProcessor, "cursorProcessor is null");
        this.pageProcessor = Objects.requireNonNull(pageProcessor, "pageProcessor is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.planNodeId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.types = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
        this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
        this.pageBuilder = new PageBuilder(this.getTypes());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkState((this.split == null ? 1 : 0) != 0, (Object)"Table scan split already set");
        if (this.finishing) {
            return Optional::empty;
        }
        this.split = split;
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier(() -> splitInfo);
        }
        this.blocked.set(null);
        return () -> {
            if (this.pageSource instanceof UpdatablePageSource) {
                return Optional.of((UpdatablePageSource)this.pageSource);
            }
            return Optional.empty();
        };
    }

    @Override
    public void noMoreSplits() {
        if (this.split == null) {
            this.finishing = true;
        }
        this.blocked.set(null);
    }

    @Override
    public final List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void close() {
        this.finish();
    }

    @Override
    public void finish() {
        this.blocked.set(null);
        if (this.pageSource != null) {
            try {
                this.pageSource.close();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else if (this.cursor != null) {
            this.cursor.close();
        }
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        if (!this.finishing) {
            this.createSourceIfNecessary();
        }
        if (this.pageSource != null && this.pageSource.isFinished() && this.currentPage == null) {
            this.finishing = true;
        }
        return this.finishing && this.pageBuilder.isEmpty();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.blocked;
    }

    @Override
    public final boolean needsInput() {
        return false;
    }

    @Override
    public final void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.finishing) {
            this.createSourceIfNecessary();
            if (this.cursor != null) {
                int rowsProcessed = this.cursorProcessor.process(this.operatorContext.getSession().toConnectorSession(), this.cursor, 16384, this.pageBuilder);
                long bytesProcessed = this.cursor.getCompletedBytes() - this.completedBytes;
                long elapsedNanos = this.cursor.getReadTimeNanos() - this.readTimeNanos;
                this.operatorContext.recordGeneratedInput(bytesProcessed, rowsProcessed, elapsedNanos);
                this.completedBytes = this.cursor.getCompletedBytes();
                this.readTimeNanos = this.cursor.getReadTimeNanos();
                if (rowsProcessed == 0) {
                    this.finishing = true;
                }
            } else {
                if (this.currentPage == null) {
                    this.currentPage = this.pageSource.getNextPage();
                    if (this.currentPage != null) {
                        long endCompletedBytes = this.pageSource.getCompletedBytes();
                        long endReadTimeNanos = this.pageSource.getReadTimeNanos();
                        this.operatorContext.recordGeneratedInput(endCompletedBytes - this.completedBytes, this.currentPage.getPositionCount(), endReadTimeNanos - this.readTimeNanos);
                        this.completedBytes = endCompletedBytes;
                        this.readTimeNanos = endReadTimeNanos;
                    }
                    this.currentPosition = 0;
                }
                if (this.currentPage != null) {
                    this.currentPosition = this.pageProcessor.process(this.operatorContext.getSession().toConnectorSession(), this.currentPage, this.currentPosition, this.currentPage.getPositionCount(), this.pageBuilder);
                    if (this.currentPosition == this.currentPage.getPositionCount()) {
                        this.currentPage = null;
                        this.currentPosition = 0;
                    }
                }
            }
        }
        if (this.pageBuilder.isEmpty() || !this.finishing && !this.pageBuilder.isFull()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    private void createSourceIfNecessary() {
        if (this.split != null && this.pageSource == null && this.cursor == null) {
            ConnectorPageSource source = this.pageSourceProvider.createPageSource(this.operatorContext.getSession(), this.split, this.columns);
            if (source instanceof RecordPageSource) {
                this.cursor = ((RecordPageSource)source).getCursor();
            } else {
                this.pageSource = source;
            }
        }
    }

    public static class ScanFilterAndProjectOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final CursorProcessor cursorProcessor;
        private final PageProcessor pageProcessor;
        private final PlanNodeId sourceId;
        private final PageSourceProvider pageSourceProvider;
        private final List<ColumnHandle> columns;
        private final List<Type> types;
        private boolean closed;

        public ScanFilterAndProjectOperatorFactory(int operatorId, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, Iterable<ColumnHandle> columns, List<Type> types) {
            this.operatorId = operatorId;
            this.cursorProcessor = Objects.requireNonNull(cursorProcessor, "cursorProcessor is null");
            this.pageProcessor = Objects.requireNonNull(pageProcessor, "pageProcessor is null");
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.types = Objects.requireNonNull(types, "types is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, ScanFilterAndProjectOperator.class.getSimpleName());
            return new ScanFilterAndProjectOperator(operatorContext, this.sourceId, this.pageSourceProvider, this.cursorProcessor, this.pageProcessor, this.columns, this.types);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

