/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.HashPagePartitionFunction;
import com.facebook.presto.OutputBuffers;
import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.PartitionedPagePartitionFunction;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PartitionGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;

public class PartitionedOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final ListenableFuture<PartitionFunction> partitionFunction;
    private ListenableFuture<?> blocked = NOT_BLOCKED;
    private boolean finished;

    public PartitionedOutputOperator(OperatorContext operatorContext, List<Type> sourceTypes, SharedBuffer sharedBuffer) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.partitionFunction = Futures.transform(sharedBuffer.getFinalOutputBuffers(), outputBuffers -> new PartitionFunction(sharedBuffer, sourceTypes, (OutputBuffers)outputBuffers));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    @Override
    public void finish() {
        this.finished = true;
        this.blocked = ((PartitionFunction)Futures.getUnchecked(this.partitionFunction)).flush(true);
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.partitionFunction.isDone()) {
            return this.partitionFunction;
        }
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((boolean)this.isBlocked().isDone(), (Object)"output is already blocked");
        if (page.getPositionCount() == 0) {
            return;
        }
        this.blocked = ((PartitionFunction)Futures.getUnchecked(this.partitionFunction)).partitionPage(page);
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    private static class PartitionFunction {
        private final SharedBuffer sharedBuffer;
        private final List<Type> sourceTypes;
        private final PartitionGenerator partitionGenerator;
        private final int partitionCount;
        private final List<PageBuilder> pageBuilders;
        private final OptionalInt nullChannel;

        public PartitionFunction(SharedBuffer sharedBuffer, List<Type> sourceTypes, OutputBuffers outputBuffers) {
            this.sharedBuffer = Objects.requireNonNull(sharedBuffer, "sharedBuffer is null");
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            Preconditions.checkArgument((boolean)outputBuffers.isNoMoreBufferIds(), (Object)"output buffers is not final version");
            Map<TaskId, PagePartitionFunction> buffers = outputBuffers.getBuffers();
            Preconditions.checkArgument((!buffers.isEmpty() ? 1 : 0) != 0, (Object)"output buffers is empty");
            Preconditions.checkArgument((boolean)buffers.values().stream().allMatch(PartitionedPagePartitionFunction.class::isInstance), (Object)"None of the buffers can be unpartitioned");
            Collection<PagePartitionFunction> partitionFunctions = buffers.values();
            Preconditions.checkArgument((partitionFunctions.stream().map(PagePartitionFunction::getPartitionCount).distinct().count() == 1L ? 1 : 0) != 0, (Object)"All buffers must have the same partition count");
            Preconditions.checkArgument((partitionFunctions.stream().map(PagePartitionFunction::getPartition).distinct().count() == (long)partitionFunctions.size() ? 1 : 0) != 0, (Object)"All buffers must have a different partition");
            PagePartitionFunction partitionFunction = partitionFunctions.stream().findAny().get();
            if (partitionFunction instanceof HashPagePartitionFunction) {
                HashPagePartitionFunction hashPartitionFunction = (HashPagePartitionFunction)partitionFunction;
                this.partitionGenerator = PartitionGenerator.createHashPartitionGenerator(hashPartitionFunction.getHashChannel(), hashPartitionFunction.getPartitioningChannels(), hashPartitionFunction.getTypes());
                if (hashPartitionFunction.getNullPartitioning() == PlanFragment.NullPartitioning.REPLICATE) {
                    List<Integer> partitioningChannels = hashPartitionFunction.getPartitioningChannels();
                    Preconditions.checkState((partitioningChannels.size() == 1 ? 1 : 0) != 0);
                    this.nullChannel = OptionalInt.of((Integer)Iterables.getOnlyElement(partitioningChannels));
                } else {
                    this.nullChannel = OptionalInt.empty();
                }
            } else {
                this.partitionGenerator = PartitionGenerator.createRoundRobinPartitionGenerator();
                this.nullChannel = OptionalInt.empty();
            }
            this.partitionCount = partitionFunction.getPartitionCount();
            ImmutableList.Builder pageBuilders = ImmutableList.builder();
            for (int i = 0; i < this.partitionCount; ++i) {
                pageBuilders.add((Object)new PageBuilder(sourceTypes));
            }
            this.pageBuilders = pageBuilders.build();
        }

        public ListenableFuture<?> partitionPage(Page page) {
            Objects.requireNonNull(page, "page is null");
            for (int position = 0; position < page.getPositionCount(); ++position) {
                Type type;
                int channel;
                PageBuilder pageBuilder;
                if (this.nullChannel.isPresent() && page.getBlock(this.nullChannel.getAsInt()).isNull(position)) {
                    for (int i = 0; i < this.partitionCount; ++i) {
                        pageBuilder = this.pageBuilders.get(i);
                        pageBuilder.declarePosition();
                        for (channel = 0; channel < this.sourceTypes.size(); ++channel) {
                            type = this.sourceTypes.get(channel);
                            type.appendTo(page.getBlock(channel), position, pageBuilder.getBlockBuilder(channel));
                        }
                    }
                    continue;
                }
                int partitionHashBucket = this.partitionGenerator.getPartitionBucket(this.partitionCount, position, page);
                pageBuilder = this.pageBuilders.get(partitionHashBucket);
                pageBuilder.declarePosition();
                for (channel = 0; channel < this.sourceTypes.size(); ++channel) {
                    type = this.sourceTypes.get(channel);
                    type.appendTo(page.getBlock(channel), position, pageBuilder.getBlockBuilder(channel));
                }
            }
            return this.flush(false);
        }

        public ListenableFuture<?> flush(boolean force) {
            ArrayList blockedFutures = new ArrayList();
            for (int partition = 0; partition < this.partitionCount; ++partition) {
                PageBuilder partitionPageBuilder = this.pageBuilders.get(partition);
                if (partitionPageBuilder.isEmpty() || !force && !partitionPageBuilder.isFull()) continue;
                Page pagePartition = partitionPageBuilder.build();
                partitionPageBuilder.reset();
                blockedFutures.add(this.sharedBuffer.enqueue(partition, pagePartition));
            }
            ListenableFuture future = Futures.allAsList(blockedFutures);
            if (future.isDone()) {
                return Operator.NOT_BLOCKED;
            }
            return future;
        }
    }

    public static class PartitionedOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> sourceTypes;
        private final SharedBuffer sharedBuffer;

        public PartitionedOutputOperatorFactory(int operatorId, List<Type> sourceTypes, SharedBuffer sharedBuffer) {
            this.operatorId = operatorId;
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.sharedBuffer = Objects.requireNonNull(sharedBuffer, "sharedBuffer is null");
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, PartitionedOutputOperator.class.getSimpleName());
            return new PartitionedOutputOperator(operatorContext, this.sourceTypes, this.sharedBuffer);
        }

        @Override
        public void close() {
        }
    }

    public static class PartitionedOutputFactory
    implements OutputFactory {
        private final SharedBuffer sharedBuffer;

        public PartitionedOutputFactory(SharedBuffer sharedBuffer) {
            this.sharedBuffer = Objects.requireNonNull(sharedBuffer, "sharedBuffer is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, List<Type> sourceTypes) {
            return new PartitionedOutputOperatorFactory(operatorId, sourceTypes, this.sharedBuffer);
        }
    }
}

