/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HashAggregationOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> groupByTypes;
    private final List<Integer> groupByChannels;
    private final AggregationNode.Step step;
    private final List<AccumulatorFactory> accumulatorFactories;
    private final Optional<Integer> maskChannel;
    private final Optional<Integer> hashChannel;
    private final int expectedGroups;
    private final List<Type> types;
    private GroupByHashAggregationBuilder aggregationBuilder;
    private Iterator<Page> outputIterator;
    private boolean finishing;

    public HashAggregationOperator(OperatorContext operatorContext, List<Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, Optional<Integer> maskChannel, Optional<Integer> hashChannel, int expectedGroups) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(step, "step is null");
        Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.groupByTypes = ImmutableList.copyOf(groupByTypes);
        this.groupByChannels = ImmutableList.copyOf(groupByChannels);
        this.accumulatorFactories = ImmutableList.copyOf(accumulatorFactories);
        this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
        this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
        this.step = step;
        this.expectedGroups = expectedGroups;
        this.types = HashAggregationOperator.toTypes(groupByTypes, step, accumulatorFactories, hashChannel);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.aggregationBuilder == null && (this.outputIterator == null || !this.outputIterator.hasNext());
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && (this.aggregationBuilder == null || !this.aggregationBuilder.isFull());
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        if (this.aggregationBuilder == null) {
            this.aggregationBuilder = new GroupByHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.maskChannel, this.hashChannel, this.operatorContext);
        } else {
            Preconditions.checkState((!this.aggregationBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        }
        this.aggregationBuilder.processPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            this.outputIterator = null;
            if (this.aggregationBuilder == null) {
                return null;
            }
            if (!this.finishing && !this.aggregationBuilder.isFull()) {
                return null;
            }
            this.outputIterator = this.aggregationBuilder.build();
            this.aggregationBuilder = null;
            if (!this.outputIterator.hasNext()) {
                this.outputIterator = null;
                return null;
            }
        }
        return this.outputIterator.next();
    }

    private static List<Type> toTypes(List<? extends Type> groupByType, AggregationNode.Step step, List<AccumulatorFactory> factories, Optional<Integer> hashChannel) {
        ImmutableList.Builder types = ImmutableList.builder();
        types.addAll(groupByType);
        if (hashChannel.isPresent()) {
            types.add((Object)BigintType.BIGINT);
        }
        for (AccumulatorFactory factory : factories) {
            types.add((Object)new Aggregator(factory, step).getType());
        }
        return types.build();
    }

    private static class Aggregator {
        private final GroupedAccumulator aggregation;
        private final AggregationNode.Step step;
        private final int intermediateChannel;

        private Aggregator(AccumulatorFactory accumulatorFactory, AggregationNode.Step step) {
            if (step.isInputRaw()) {
                this.intermediateChannel = -1;
                this.aggregation = accumulatorFactory.createGroupedAccumulator();
            } else {
                Preconditions.checkArgument((accumulatorFactory.getInputChannels().size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
                this.intermediateChannel = accumulatorFactory.getInputChannels().get(0);
                this.aggregation = accumulatorFactory.createGroupedIntermediateAccumulator();
            }
            this.step = step;
        }

        public long getEstimatedSize() {
            return this.aggregation.getEstimatedSize();
        }

        public Type getType() {
            if (this.step.isOutputPartial()) {
                return this.aggregation.getIntermediateType();
            }
            return this.aggregation.getFinalType();
        }

        public void processPage(GroupByIdBlock groupIds, Page page) {
            if (this.step.isInputRaw()) {
                this.aggregation.addInput(groupIds, page);
            } else {
                this.aggregation.addIntermediate(groupIds, page.getBlock(this.intermediateChannel));
            }
        }

        public void evaluate(int groupId, BlockBuilder output) {
            if (this.step.isOutputPartial()) {
                this.aggregation.evaluateIntermediate(groupId, output);
            } else {
                this.aggregation.evaluateFinal(groupId, output);
            }
        }
    }

    private static class GroupByHashAggregationBuilder {
        private final GroupByHash groupByHash;
        private final List<Aggregator> aggregators;
        private final OperatorContext operatorContext;
        private final boolean partial;

        private GroupByHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> maskChannel, Optional<Integer> hashChannel, OperatorContext operatorContext) {
            this.groupByHash = GroupByHash.createGroupByHash(groupByTypes, Ints.toArray(groupByChannels), maskChannel, hashChannel, expectedGroups);
            this.operatorContext = operatorContext;
            this.partial = step.isOutputPartial();
            ImmutableList.Builder builder = ImmutableList.builder();
            Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
            for (int i = 0; i < accumulatorFactories.size(); ++i) {
                AccumulatorFactory accumulatorFactory = accumulatorFactories.get(i);
                builder.add((Object)new Aggregator(accumulatorFactory, step));
            }
            this.aggregators = builder.build();
        }

        private void processPage(Page page) {
            if (this.aggregators.isEmpty()) {
                this.groupByHash.addPage(page);
                return;
            }
            GroupByIdBlock groupIds = this.groupByHash.getGroupIds(page);
            for (Aggregator aggregator : this.aggregators) {
                aggregator.processPage(groupIds, page);
            }
        }

        public boolean isFull() {
            long memorySize = this.groupByHash.getEstimatedSize();
            for (Aggregator aggregator : this.aggregators) {
                memorySize += aggregator.getEstimatedSize();
            }
            if ((memorySize -= this.operatorContext.getOperatorPreAllocatedMemory().toBytes()) < 0L) {
                memorySize = 0L;
            }
            if (this.partial) {
                return !this.operatorContext.trySetMemoryReservation(memorySize);
            }
            this.operatorContext.setMemoryReservation(memorySize);
            return false;
        }

        public Iterator<Page> build() {
            ArrayList<Type> types = new ArrayList<Type>(this.groupByHash.getTypes());
            for (Aggregator aggregator : this.aggregators) {
                types.add(aggregator.getType());
            }
            final PageBuilder pageBuilder = new PageBuilder(types);
            return new AbstractIterator<Page>(){
                private final int groupCount;
                private int groupId;
                {
                    this.groupCount = groupByHash.getGroupCount();
                }

                protected Page computeNext() {
                    if (this.groupId >= this.groupCount) {
                        return (Page)this.endOfData();
                    }
                    pageBuilder.reset();
                    List<Type> types = groupByHash.getTypes();
                    while (!pageBuilder.isFull() && this.groupId < this.groupCount) {
                        groupByHash.appendValuesTo(this.groupId, pageBuilder, 0);
                        pageBuilder.declarePosition();
                        for (int i = 0; i < aggregators.size(); ++i) {
                            Aggregator aggregator = (Aggregator)aggregators.get(i);
                            BlockBuilder output = pageBuilder.getBlockBuilder(types.size() + i);
                            aggregator.evaluate(this.groupId, output);
                        }
                        ++this.groupId;
                    }
                    return pageBuilder.build();
                }
            };
        }
    }

    public static class HashAggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final Optional<Integer> maskChannel;
        private final List<Type> groupByTypes;
        private final List<Integer> groupByChannels;
        private final AggregationNode.Step step;
        private final List<AccumulatorFactory> accumulatorFactories;
        private final Optional<Integer> hashChannel;
        private final int expectedGroups;
        private final List<Type> types;
        private boolean closed;
        private final long maxPartialMemory;

        public HashAggregationOperatorFactory(int operatorId, List<? extends Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, Optional<Integer> maskChannel, Optional<Integer> hashChannel, int expectedGroups, DataSize maxPartialMemory) {
            this.operatorId = operatorId;
            this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.groupByTypes = ImmutableList.copyOf(groupByTypes);
            this.groupByChannels = ImmutableList.copyOf(groupByChannels);
            this.step = step;
            this.accumulatorFactories = ImmutableList.copyOf(accumulatorFactories);
            this.expectedGroups = expectedGroups;
            this.maxPartialMemory = Objects.requireNonNull(maxPartialMemory, "maxPartialMemory is null").toBytes();
            this.types = HashAggregationOperator.toTypes(groupByTypes, step, accumulatorFactories, hashChannel);
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = this.step.isOutputPartial() ? driverContext.addOperatorContext(this.operatorId, HashAggregationOperator.class.getSimpleName(), this.maxPartialMemory) : driverContext.addOperatorContext(this.operatorId, HashAggregationOperator.class.getSimpleName());
            HashAggregationOperator hashAggregationOperator = new HashAggregationOperator(operatorContext, this.groupByTypes, this.groupByChannels, this.step, this.accumulatorFactories, this.maskChannel, this.hashChannel, this.expectedGroups);
            return hashAggregationOperator;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

